/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneratedSourcesFilter {
    public static final ExtensionPointName<GeneratedSourcesFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.generatedSourcesFilter");

    public static boolean isGeneratedSourceByAnyFilter(@NotNull VirtualFile file, @NotNull Project project) {
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed() || !file.isValid()) {
                return false;
            }
            for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])EP_NAME.getExtensions()) {
                if (!filter.isGeneratedSource(file, project)) continue;
                return true;
            }
            return false;
        });
    }

    public abstract boolean isGeneratedSource(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public List<? extends PsiElement> getOriginalElements(@NotNull PsiElement element) {
        return Collections.emptyList();
    }

    public @NlsContexts.LinkLabel @Nullable String getNotificationText(@NotNull VirtualFile file, @NotNull Project project) {
        return null;
    }
}

