/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndexFacade {
    protected final Project myProject;

    protected FileIndexFacade(@NotNull Project project) {
        this.myProject = project;
    }

    public static FileIndexFacade getInstance(Project project) {
        return (FileIndexFacade)project.getService(FileIndexFacade.class);
    }

    public abstract boolean isInContent(@NotNull VirtualFile var1);

    public abstract boolean isInSource(@NotNull VirtualFile var1);

    public abstract boolean isInSourceContent(@NotNull VirtualFile var1);

    public abstract boolean isInLibraryClasses(@NotNull VirtualFile var1);

    public abstract boolean isInLibrarySource(@NotNull VirtualFile var1);

    public abstract boolean isExcludedFile(@NotNull VirtualFile var1);

    public abstract boolean isUnderIgnored(@NotNull VirtualFile var1);

    @Nullable
    public abstract Module getModuleForFile(@NotNull VirtualFile var1);

    public abstract boolean isValidAncestor(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @Deprecated
    public boolean shouldBeFound(@NotNull GlobalSearchScope scope, @NotNull VirtualFile virtualFile2) {
        return true;
    }

    @NotNull
    public abstract ModificationTracker getRootModificationTracker();

    @NotNull
    public abstract Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions();

    public boolean isInProjectScope(@NotNull VirtualFile file) {
        if (this.isInLibraryClasses(file) && !this.isInSourceContent(file)) {
            return false;
        }
        return this.isInContent(file);
    }
}

