/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class ProjectLocator {
    private static ProjectLocator ourInstance = CachedSingletonsRegistry.markCachedField(ProjectLocator.class);
    private static final ThreadLocal<Map<VirtualFile, Project>> ourPreferredProjects = ThreadLocal.withInitial(() -> new HashMap());

    public static ProjectLocator getInstance() {
        ProjectLocator result = ourInstance;
        if (result == null) {
            ourInstance = result = (ProjectLocator)ApplicationManager.getApplication().getService(ProjectLocator.class);
        }
        return result;
    }

    @Nullable
    public abstract Project guessProjectForFile(@Nullable VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(@NotNull VirtualFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithPreferredProject(@NotNull VirtualFile file, @NotNull Project preferredProject, @NotNull ThrowableComputable<T, E> runnable) throws E {
        Map<VirtualFile, Project> local = ourPreferredProjects.get();
        Project prev = local.put(file, preferredProject);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            if (prev == null) {
                local.remove(file);
            } else {
                local.put(file, prev);
            }
        }
    }

    @Nullable
    static Project getPreferredProject(@NotNull VirtualFile file) {
        return ourPreferredProjects.get().get(file);
    }
}

