/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class SettingsEditorConfigurable<Settings>
extends BaseConfigurable {
    private SettingsEditor<Settings> myEditor;
    private final Settings mySettings;
    private final SettingsEditorListener<Settings> myListener;
    private final JComponent myComponent;

    public SettingsEditorConfigurable(@NotNull SettingsEditor<Settings> editor, @NotNull Settings settings) {
        this.myEditor = editor;
        this.mySettings = settings;
        this.myListener = new SettingsEditorListener<Settings>(){

            @Override
            public void stateChanged(@NotNull SettingsEditor<Settings> settingsEditor) {
                SettingsEditorConfigurable.this.setModified(true);
            }
        };
        this.myEditor.addSettingsEditorListener(this.myListener);
        this.myComponent = this.myEditor.getComponent();
    }

    @Override
    public JComponent createComponent() {
        return this.myComponent;
    }

    @Override
    public void apply() throws ConfigurationException {
        this.myEditor.applyTo(this.mySettings);
        this.setModified(false);
    }

    @Override
    public void reset() {
        this.myEditor.resetFrom(this.mySettings);
        this.setModified(false);
    }

    @Override
    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.removeSettingsEditorListener(this.myListener);
            Disposer.dispose(this.myEditor);
        }
        this.myEditor = null;
    }

    @NotNull
    public SettingsEditor<Settings> getEditor() {
        return this.myEditor;
    }

    @NotNull
    public Settings getSettings() {
        return this.mySettings;
    }
}

