/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.OptionEditor;
import com.intellij.openapi.util.ClassExtension;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface OptionEditorProvider<@NotNull O> {
    public static final ClassExtension<OptionEditorProvider<?>> EXTENSION = new ClassExtension("com.intellij.ui.optionEditorProvider");

    @Contract(value="_ -> new")
    @NotNull
    public static <O> OptionEditor<O> forOptions(O options) {
        OptionEditorProvider<?> provider = Objects.requireNonNull(EXTENSION.forClass(options.getClass()), "Option editor for class " + options.getClass().getName() + " must be registered");
        return provider.createOptionEditor(options);
    }

    @Contract(value="_ -> new")
    @NotNull
    public OptionEditor<O> createOptionEditor(O var1);
}

