/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    public static Getter<FileTypeRegistry> ourInstanceGetter;

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        FileType actualType = file.getFileType();
        return actualType == type || "Scratch".equals(actualType.getName()) && type == this.getFileTypeByFileName(file.getNameSequence());
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        return language.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        if (ourInstanceGetter == null) {
            return (FileTypeRegistry)ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)"com.intellij.openapi.fileTypes.FileTypeManager");
        }
        return (FileTypeRegistry)ourInstanceGetter.get();
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file, byte @Nullable [] content) {
        return this.getFileTypeByFile(file);
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls CharSequence fileNameSeq) {
        return this.getFileTypeByFileName(fileNameSeq.toString());
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NonNls @NotNull String var1);

    @Nullable
    public abstract FileType findFileTypeByName(@NonNls @NotNull String var1);

    public static interface FileTypeDetector {
        public static final ExtensionPointName<FileTypeDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.fileTypeDetector");

        @Nullable
        public FileType detect(@NotNull VirtualFile var1, @NotNull ByteSequence var2, @Nullable CharSequence var3);

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        @Nullable
        default public Collection<? extends FileType> getDetectedFileTypes() {
            return null;
        }

        default public int getDesiredContentPrefixLength() {
            return 1024;
        }

        @Deprecated
        default public int getVersion() {
            return 0;
        }
    }
}

