/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenFileDescriptor
implements Navigatable,
Comparable<OpenFileDescriptor> {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create("NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    private boolean myUseCurrentWindow;
    private ScrollType myScrollType = ScrollType.CENTER;

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        this(project, file, -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn) {
        this(project, file, logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, boolean persistent) {
        this(project, file, logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file) {
        this(project, file, -1, -1, -1, false);
    }

    private OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        this.myProject = project;
        this.myFile = file;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    @Override
    public void navigate(boolean requestFocus) {
        FileNavigator.getInstance().navigate(this, requestFocus);
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        return FileNavigator.getInstance().navigateInEditor(this, requestFocus);
    }

    public void navigateIn(@NotNull Editor e) {
        OpenFileDescriptor.navigateInEditor(this, e);
    }

    protected static void navigateInEditor(@NotNull OpenFileDescriptor descriptor, @NotNull Editor e) {
        int offset = descriptor.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (descriptor.getLine() >= 0) {
            LogicalPosition pos = new LogicalPosition(descriptor.getLine(), Math.max(descriptor.getColumn(), 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            FileEditorManager.getInstance(descriptor.getProject()).runWhenLoaded(e, () -> {
                descriptor.scrollToCaret(e);
                OpenFileDescriptor.unfoldCurrentLine(e);
            });
        }
    }

    protected static void unfoldCurrentLine(@NotNull Editor editor) {
        FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor);
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : allRegions) {
                if (region.isExpanded() || !range.intersects(TextRange.create((Segment)region))) continue;
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public static TextRange getRangeToUnfoldOnNavigation(@NotNull Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int start = editor.getDocument().getLineStartOffset(line);
        int end = editor.getDocument().getLineEndOffset(line);
        return new TextRange(start, end);
    }

    private void scrollToCaret(@NotNull Editor e) {
        e.getScrollingModel().scrollToCaret(this.myScrollType);
    }

    @Override
    public boolean canNavigate() {
        return FileNavigator.getInstance().canNavigate(this.myFile);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public OpenFileDescriptor setUseCurrentWindow(boolean search) {
        this.myUseCurrentWindow = search;
        return this;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    public void setScrollType(@NotNull ScrollType scrollType) {
        this.myScrollType = scrollType;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }

    @Override
    public int compareTo(@NotNull OpenFileDescriptor o) {
        int i = this.myProject.getName().compareTo(o.myProject.getName());
        if (i != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.myFile.getName());
        if (i != 0) {
            return i;
        }
        if (this.myRangeMarker != null) {
            if (o.myRangeMarker == null) {
                return 1;
            }
            i = this.myRangeMarker.getStartOffset() - o.myRangeMarker.getStartOffset();
            if (i != 0) {
                return i;
            }
            return this.myRangeMarker.getEndOffset() - o.myRangeMarker.getEndOffset();
        }
        return o.myRangeMarker == null ? 0 : -1;
    }
}

