/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.roots.DependencyScope;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDependencyData<T extends AbstractExternalEntityData>
extends AbstractExternalEntityData
implements DependencyData<T>,
Named,
OrderAware {
    @NotNull
    private ModuleData ownerModule;
    @NotNull
    private T target;
    private DependencyScope scope = DependencyScope.COMPILE;
    private boolean exported;
    private int order;

    protected AbstractDependencyData(@NotNull ModuleData ownerModule, @NotNull T target) {
        super(ownerModule.getOwner());
        this.ownerModule = ownerModule;
        this.target = target;
    }

    @Override
    @NotNull
    public ModuleData getOwnerModule() {
        return this.ownerModule;
    }

    public void setOwnerModule(@NotNull ModuleData ownerModule) {
        this.ownerModule = ownerModule;
    }

    @Override
    @NotNull
    public T getTarget() {
        return this.target;
    }

    public void setTarget(@NotNull T target) {
        this.target = target;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        return this.scope;
    }

    public void setScope(DependencyScope scope) {
        this.scope = scope;
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    @Deprecated
    @NotNull
    public String getName() {
        return ((Named)this.target).getName();
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        ((Named)this.target).setName(name);
    }

    @Override
    @NotNull
    public String getExternalName() {
        return ((Named)this.target).getExternalName();
    }

    @Override
    public void setExternalName(@NotNull String name) {
        ((Named)this.target).setExternalName(name);
    }

    @Override
    @NotNull
    public String getInternalName() {
        return ((Named)this.target).getInternalName();
    }

    @Override
    public void setInternalName(@NotNull String name) {
        ((Named)this.target).setInternalName(name);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + this.ownerModule.hashCode();
        result = 31 * result + ((AbstractExternalEntityData)this.target).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractDependencyData that = (AbstractDependencyData)o;
        return this.scope.equals((Object)that.scope) && this.ownerModule.equals(that.ownerModule) && ((AbstractExternalEntityData)this.target).equals(that.target);
    }

    public String toString() {
        return "dependency=" + this.getTarget() + "|scope=" + (Object)((Object)this.getScope()) + "|exported=" + this.isExported() + "|owner=" + this.getOwnerModule();
    }
}

