/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpecBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean myForceWhenUptodate;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;
    private boolean isPreviewMode;
    private boolean isReportRefreshError = true;
    @Nullable
    private String myVmOptions;
    @Nullable
    private String myArguments;
    private boolean myCreateDirectoriesForEmptyContentRoots;
    @Nullable
    private ProjectResolverPolicy myProjectResolverPolicy;

    public ImportSpecBuilder(@NotNull Project project, @NotNull ProjectSystemId id) {
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.IN_BACKGROUND_ASYNC;
    }

    public ImportSpecBuilder(ImportSpec importSpec) {
        this(importSpec.getProject(), importSpec.getExternalSystemId());
        this.apply(importSpec);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public ImportSpecBuilder whenAutoImportEnabled() {
        return this;
    }

    public ImportSpecBuilder use(@NotNull ProgressExecutionMode executionMode) {
        this.myProgressExecutionMode = executionMode;
        return this;
    }

    public ImportSpecBuilder forceWhenUptodate() {
        return this.forceWhenUptodate(true);
    }

    public ImportSpecBuilder forceWhenUptodate(boolean force) {
        this.myForceWhenUptodate = force;
        return this;
    }

    public ImportSpecBuilder callback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
        return this;
    }

    public ImportSpecBuilder usePreviewMode() {
        this.isPreviewMode = true;
        return this;
    }

    public ImportSpecBuilder createDirectoriesForEmptyContentRoots() {
        this.myCreateDirectoriesForEmptyContentRoots = true;
        return this;
    }

    public ImportSpecBuilder dontReportRefreshErrors() {
        this.isReportRefreshError = false;
        return this;
    }

    public ImportSpecBuilder withVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    public ImportSpecBuilder withArguments(@Nullable String arguments) {
        this.myArguments = arguments;
        return this;
    }

    @ApiStatus.Experimental
    public ImportSpecBuilder projectResolverPolicy(@NotNull ProjectResolverPolicy projectResolverPolicy) {
        this.myProjectResolverPolicy = projectResolverPolicy;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public ImportSpecBuilder useDefaultCallback() {
        this.callback(null);
        return this;
    }

    public ImportSpec build() {
        ImportSpecImpl mySpec = new ImportSpecImpl(this.myProject, this.myExternalSystemId);
        mySpec.setProgressExecutionMode(this.myProgressExecutionMode);
        mySpec.setForceWhenUptodate(this.myForceWhenUptodate);
        mySpec.setCreateDirectoriesForEmptyContentRoots(this.myCreateDirectoriesForEmptyContentRoots);
        mySpec.setPreviewMode(this.isPreviewMode);
        mySpec.setReportRefreshError(this.isReportRefreshError);
        mySpec.setArguments(this.myArguments);
        mySpec.setVmOptions(this.myVmOptions);
        mySpec.setProjectResolverPolicy(this.myProjectResolverPolicy);
        ExternalProjectRefreshCallback callback = this.myCallback != null ? this.myCallback : (this.myProjectResolverPolicy == null || !this.myProjectResolverPolicy.isPartialDataResolveAllowed() ? new DefaultProjectRefreshCallback(mySpec) : null);
        mySpec.setCallback(callback);
        return mySpec;
    }

    private void apply(ImportSpec spec) {
        this.myProgressExecutionMode = spec.getProgressExecutionMode();
        this.myForceWhenUptodate = spec.isForceWhenUptodate();
        this.myCreateDirectoriesForEmptyContentRoots = spec.shouldCreateDirectoriesForEmptyContentRoots();
        this.myCallback = spec.getCallback();
        this.isPreviewMode = spec.isPreviewMode();
        this.isReportRefreshError = spec.isReportRefreshError();
        this.myArguments = spec.getArguments();
        this.myVmOptions = spec.getVmOptions();
    }

    @ApiStatus.Internal
    public static final class DefaultProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        private final Project myProject;
        private final ProgressExecutionMode myExecutionMode;

        public DefaultProjectRefreshCallback(ImportSpec spec) {
            this.myProject = spec.getProject();
            this.myExecutionMode = spec.getProgressExecutionMode();
        }

        @Override
        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            boolean synchronous = this.myExecutionMode == ProgressExecutionMode.MODAL_SYNC;
            ServiceManager.getService(ProjectDataManager.class).importData(externalProject, this.myProject, synchronous);
        }
    }
}

