/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public interface BulkAwareDocumentListener
extends DocumentListener {
    @Override
    default public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (!event.getDocument().isInBulkUpdate()) {
            this.beforeDocumentChangeNonBulk(event);
        }
    }

    @Override
    default public void documentChanged(@NotNull DocumentEvent event) {
        if (!event.getDocument().isInBulkUpdate()) {
            this.documentChangedNonBulk(event);
        }
    }

    default public void beforeDocumentChangeNonBulk(@NotNull DocumentEvent event) {
    }

    default public void documentChangedNonBulk(@NotNull DocumentEvent event) {
    }

    public static interface Simple
    extends BulkAwareDocumentListener {
        @Override
        default public void beforeDocumentChangeNonBulk(@NotNull DocumentEvent event) {
            this.beforeDocumentChange(event.getDocument());
        }

        @Override
        default public void documentChangedNonBulk(@NotNull DocumentEvent event) {
            this.afterDocumentChange(event.getDocument());
        }

        @Override
        default public void bulkUpdateStarting(@NotNull Document document) {
            this.beforeDocumentChange(document);
        }

        @Override
        default public void bulkUpdateFinished(@NotNull Document document) {
            this.afterDocumentChange(document);
        }

        default public void beforeDocumentChange(@NotNull Document document) {
        }

        default public void afterDocumentChange(@NotNull Document document) {
        }
    }
}

