/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.reporting.FreezeLogger;
import com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedAction {
    private static final Logger LOG = Logger.getInstance(EditorActionHandlerBean.class);
    private static final ExtensionPointName<EditorTypedHandlerBean> EP_NAME = new ExtensionPointName("com.intellij.editorTypedHandler");
    private static final ExtensionPointName<EditorTypedHandlerBean> RAW_EP_NAME = new ExtensionPointName("com.intellij.rawEditorTypedHandler");
    private TypedActionHandler myRawHandler;
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    public static TypedAction getInstance() {
        return (TypedAction)ApplicationManager.getApplication().getService(TypedAction.class);
    }

    private void ensureHandlersLoaded() {
        if (this.myHandlersLoaded) {
            return;
        }
        this.myHandlersLoaded = true;
        DefaultPicoContainer container = new DefaultPicoContainer((DefaultPicoContainer)ApplicationManager.getApplication().getPicoContainer());
        EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myHandler, container, pluginDescriptor);
            if (handler != null) {
                this.myHandler = handler;
            }
        });
    }

    @Nullable
    private static TypedActionHandler getOrCreateHandler(@NotNull EditorTypedHandlerBean bean, @NotNull TypedActionHandler originalHandler, @NotNull DefaultPicoContainer container, @NotNull PluginDescriptor pluginDescriptor) {
        TypedActionHandler handler;
        try {
            container.unregisterComponent(TypedActionHandler.class);
            container.registerComponentInstance(TypedActionHandler.class, (Object)originalHandler);
            handler = bean.getHandler(container, pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
            return null;
        }
        return handler;
    }

    private void loadRawHandlers() {
        DefaultPicoContainer container = new DefaultPicoContainer((DefaultPicoContainer)ApplicationManager.getApplication().getPicoContainer());
        RAW_EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myRawHandler, container, pluginDescriptor);
            if (handler != null) {
                this.myRawHandler = handler;
            }
        });
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    @Deprecated
    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        return this.myRawHandler;
    }

    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        if (tmp == null) {
            this.loadRawHandlers();
        }
        return tmp;
    }

    public void beforeActionPerformed(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (this.myRawHandler instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)this.myRawHandler).beforeExecute(editor, c, context, plan);
        }
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        FreezeLogger.getInstance().runUnderPerformanceMonitor(project, () -> this.myRawHandler.execute(editor, charTyped, dataContext));
    }

    private static final class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

