/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAwareLineWrapPositionStrategy
implements LineWrapPositionStrategy {
    private static final Logger LOG = Logger.getInstance(PsiAwareLineWrapPositionStrategy.class);
    private final TokenSet myEnabledTypes;
    private final boolean myNonVirtualOnly;
    public static final int NO_ELEMENT_WRAP = -1;
    public static final int NO_LINE_WRAP = -2;

    public PsiAwareLineWrapPositionStrategy(boolean nonVirtualOnly, IElementType ... enabledTypes) {
        this.myEnabledTypes = TokenSet.create(enabledTypes);
        this.myNonVirtualOnly = nonVirtualOnly;
        if (enabledTypes.length <= 0) {
            LOG.warn(String.format("%s instance is created with empty token/element types. That will lead to inability to perform line wrap", this.getClass().getName()));
        }
    }

    @Override
    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (isSoftWrap && this.myNonVirtualOnly) {
            LineWrapPositionStrategy implementation = LanguageLineWrapPositionStrategy.INSTANCE.getDefaultImplementation();
            return implementation.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
        }
        if (project == null) {
            return -1;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        if (documentManager == null) {
            return -1;
        }
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return -1;
        }
        documentManager.commitDocument(document);
        PsiElement element = psiFile.findElementAt(maxPreferredOffset);
        if (element == null) {
            return -1;
        }
        while (element != null && element.getTextRange().getEndOffset() > startOffset) {
            if (this.allowToWrapInside(element)) {
                int end;
                TextRange textRange = element.getTextRange();
                int start = Math.max(textRange.getStartOffset(), startOffset);
                int result = this.doCalculateWrapPosition(document, project, element, start, end = Math.min(textRange.getEndOffset(), endOffset), maxPreferredOffset, isSoftWrap);
                if (result >= 0) {
                    return result;
                }
                if (result == -2) break;
                if (end <= maxPreferredOffset) {
                    return end;
                }
                if (start > startOffset) {
                    return start;
                }
            }
            element = PsiAwareLineWrapPositionStrategy.getPrevious(element);
        }
        return -1;
    }

    protected abstract int doCalculateWrapPosition(@NotNull Document var1, @Nullable Project var2, @NotNull PsiElement var3, int var4, int var5, int var6, boolean var7);

    private boolean allowToWrapInside(@NotNull PsiElement element) {
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return false;
        }
        for (PsiElement parent = element; parent != null && textRange.equals((Object)parent.getTextRange()); parent = parent.getParent()) {
            ASTNode parentNode = parent.getNode();
            if (parentNode == null || !this.myEnabledTypes.contains(parentNode.getElementType())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getPrevious(@NotNull PsiElement element) {
        PsiElement result = element.getPrevSibling();
        if (result != null) {
            return result;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement parentSibling = null;
        while (parent != null && parentSibling == null) {
            parentSibling = parent.getPrevSibling();
            parent = parent.getParent();
        }
        if (parentSibling == null) {
            return null;
        }
        result = parentSibling.getLastChild();
        return result == null ? parentSibling : result;
    }
}

