/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import org.jetbrains.annotations.NotNull;

public class LanguageLineWrapPositionStrategy
extends LanguageExtension<LineWrapPositionStrategy> {
    public static final ExtensionPointName<? extends KeyedLazyInstance<LineWrapPositionStrategy>> EP_NAME = new ExtensionPointName("com.intellij.lang.lineWrapStrategy");
    public static final LanguageLineWrapPositionStrategy INSTANCE = new LanguageLineWrapPositionStrategy();

    private LanguageLineWrapPositionStrategy() {
        super(EP_NAME, new DefaultLineWrapPositionStrategy());
    }

    @NotNull
    public LineWrapPositionStrategy forEditor(@NotNull Editor editor) {
        PsiFile psiFile;
        LineWrapPositionStrategy result = this.getDefaultImplementation();
        Project project = editor.getProject();
        if (project != null && !project.isDisposed() && (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null) {
            result = (LineWrapPositionStrategy)INSTANCE.forLanguage(psiFile.getLanguage());
        }
        return result;
    }

    @Override
    @NotNull
    public LineWrapPositionStrategy getDefaultImplementation() {
        return (LineWrapPositionStrategy)super.getDefaultImplementation();
    }
}

