/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CaretVisualAttributes {
    public static final CaretVisualAttributes DEFAULT = new CaretVisualAttributes(null, Weight.NORMAL);
    @Nullable
    private final Color myColor;
    @NotNull
    private final Weight myWeight;

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight) {
        this.myColor = color;
        this.myWeight = weight;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    @NotNull
    public Weight getWeight() {
        return this.myWeight;
    }

    public int getWidth(int defaultWidth) {
        return Math.max(1, defaultWidth + this.myWeight.delta);
    }

    public static enum Weight {
        THIN(-1),
        NORMAL(0),
        HEAVY(1);

        private final int delta;

        private Weight(int delta) {
            this.delta = delta;
        }

        public int getDelta() {
            return this.delta;
        }
    }
}

