/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteCommandAction.class);
    private static final String DEFAULT_COMMAND_NAME = "Undefined";
    private static final String DEFAULT_GROUP_ID = null;
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project) {
        return new BuilderImpl(project, new PsiFile[0]);
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        return new BuilderImpl(first.getProject(), (PsiFile[])ArrayUtil.prepend((Object)first, (Object[])others));
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project, PsiFile ... files) {
        return new BuilderImpl(project, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        this(project, DEFAULT_COMMAND_NAME, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, PsiFile ... files) {
        this(project, commandName, DEFAULT_GROUP_ID, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, @Nullable String groupID, PsiFile ... files) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> this.performWriteCommandAction(result));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        return result;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (this.myPsiFiles.length > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        Ref resultRef = new Ref(result);
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ((RunResult)resultRef.get()).run();
            resultRef.set(null);
        }));
    }

    @Deprecated
    protected boolean isGlobalUndoAction() {
        return false;
    }

    @Deprecated
    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    @Deprecated
    protected boolean shouldRecordActionForActiveDocument() {
        return true;
    }

    @Deprecated
    public void performCommand() throws Throwable {
        RunResult[] results = new RunResult[]{new RunResult(this)};
        Ref exception = new Ref();
        this.doExecuteCommand(() -> {
            exception.set((Object)results[0].run().getThrowable());
            results[0] = null;
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void doExecuteCommand(Runnable runnable) {
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), this.shouldRecordActionForActiveDocument());
    }

    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        WriteCommandAction.runWriteCommandAction(project, DEFAULT_COMMAND_NAME, DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    public static void runWriteCommandAction(Project project, @Nls(capitalization=Nls.Capitalization.Title) @Nullable String commandName, @Nullable String groupID, @NotNull Runnable runnable, PsiFile ... files) {
        WriteCommandAction.writeCommandAction(project, files).withName(commandName).withGroupId(groupID).run(() -> runnable.run());
    }

    public static <T> T runWriteCommandAction(Project project, @NotNull Computable<T> computable) {
        return (T)WriteCommandAction.writeCommandAction(project).compute(() -> computable.compute());
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, @NotNull ThrowableComputable<T, E> computable) throws E {
        return WriteCommandAction.writeCommandAction(project).compute(computable);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_GROUP_ID;
    }

    @Deprecated
    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result) throws Throwable {
            this.run();
        }

        protected abstract void run() throws Throwable;
    }

    private static class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final PsiFile[] myFiles;
        private String myCommandName = "Undefined";
        private String myGroupId = WriteCommandAction.access$000();
        private UndoConfirmationPolicy myPolicy;
        private boolean myGlobalUndoAction;
        private boolean myShouldRecordActionForActiveDocument = true;

        private BuilderImpl(Project project, PsiFile ... files) {
            this.myProject = project;
            this.myFiles = files;
        }

        @Override
        @NotNull
        public Builder withName(String name) {
            this.myCommandName = name;
            return this;
        }

        @Override
        @NotNull
        public Builder withGlobalUndo() {
            this.myGlobalUndoAction = true;
            return this;
        }

        @Override
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean value) {
            this.myShouldRecordActionForActiveDocument = value;
            return this;
        }

        @Override
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy policy) {
            if (this.myPolicy != null) {
                throw new IllegalStateException("do not call withUndoConfirmationPolicy() several times");
            }
            this.myPolicy = policy;
            return this;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            return this;
        }

        @Override
        public <E extends Throwable> void run(final @NotNull ThrowableRunnable<E> action) {
            new MyActionWrap(){

                @Override
                protected void run(@NotNull Result result) throws Throwable {
                    action.run();
                }
            }.execute();
        }

        @Override
        public <R, E extends Throwable> R compute(final @NotNull ThrowableComputable<R, E> action) {
            return (R)new MyActionWrap<R>(){

                @Override
                protected void run(@NotNull Result<R> result) throws Throwable {
                    result.setResult(action.compute());
                }
            }.execute().getResultObject();
        }

        private abstract class MyActionWrap<T>
        extends WriteCommandAction<T> {
            MyActionWrap() {
                super(BuilderImpl.this.myProject, BuilderImpl.this.myCommandName, BuilderImpl.this.myGroupId, BuilderImpl.this.myFiles);
            }

            @Override
            @NotNull
            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return (UndoConfirmationPolicy)((Object)ObjectUtils.notNull((Object)((Object)BuilderImpl.this.myPolicy), (Object)((Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION)));
            }

            @Override
            protected boolean isGlobalUndoAction() {
                return BuilderImpl.this.myGlobalUndoAction;
            }

            @Override
            protected boolean shouldRecordActionForActiveDocument() {
                return BuilderImpl.this.myShouldRecordActionForActiveDocument;
            }
        }
    }

    public static interface Builder {
        @Contract(pure=true)
        @NotNull
        public Builder withName(@Nullable @NlsContexts.Command String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGroupId(@Nullable String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGlobalUndo();

        @Contract(pure=true)
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }
}

