/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    protected CheckboxAction() {
    }

    protected CheckboxAction(@NlsContexts.Checkbox String text) {
        super(text);
    }

    protected CheckboxAction(@NotNull Supplier<String> dynamicText) {
        super(dynamicText);
    }

    protected CheckboxAction(@NlsContexts.Checkbox String text, @NlsContexts.Tooltip String description, Icon icon) {
        super(text, description, icon);
    }

    protected CheckboxAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon) {
        super(dynamicText, dynamicDescription, icon);
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JBCheckBox checkBox = new JBCheckBox();
        checkBox.setFocusable(false);
        this.updateCustomComponent(checkBox, presentation);
        return CheckboxAction.createCheckboxComponent(checkBox, this, place);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        JComponent property = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (property instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)property;
            this.updateCustomComponent(checkBox, presentation);
        }
    }

    protected void updateCustomComponent(JCheckBox checkBox, Presentation presentation) {
        CheckboxAction.updateCheckboxPresentation(checkBox, presentation);
        checkBox.setSelected(Toggleable.isSelected(presentation));
    }

    static void updateCheckboxPresentation(JCheckBox checkBox, Presentation presentation) {
        checkBox.setText(presentation.getText(true));
        checkBox.setToolTipText(presentation.getDescription());
        checkBox.setMnemonic(presentation.getMnemonic());
        checkBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
        checkBox.setEnabled(presentation.isEnabled());
        checkBox.setVisible(presentation.isVisible());
    }

    @NotNull
    static JComponent createCheckboxComponent(@NotNull JCheckBox checkBox, final @NotNull AnAction action, final @NotNull String place) {
        checkBox.setOpaque(false);
        checkBox.setBorder((Border)JBUI.Borders.emptyRight((int)9));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                ActionToolbar actionToolbar = (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)checkBox);
                DataContext dataContext = actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext(checkBox);
                KeyEvent inputEvent = new KeyEvent(checkBox, 401, System.currentTimeMillis(), 0, 32, ' ');
                AnActionEvent event = AnActionEvent.createFromAnAction(action, inputEvent, place, dataContext);
                ActionUtil.performActionDumbAwareWithCallbacks(action, event, dataContext);
            }
        });
        return checkBox;
    }
}

