/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private final List<? extends FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<? extends FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @Override
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        ArrayList<FoldingDescriptorWrapper> descriptors = new ArrayList<FoldingDescriptorWrapper>();
        HashSet<TextRange> rangesCoveredByDescriptors = new HashSet<TextRange>();
        for (FoldingBuilder foldingBuilder : DumbService.getInstance(root.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptorsNoPlaceholderCaching(foldingBuilder, root, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor.getRange())) continue;
                descriptors.add(new FoldingDescriptorWrapper(descriptor, foldingBuilder));
            }
        }
        return descriptors.toArray(FoldingDescriptor.EMPTY);
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        return node.getText();
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        return node.getText();
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        FoldingBuilder builder = ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        return CompositeFoldingBuilder.mayUseBuilder(foldingDescriptor.getElement(), builder) && builder.isCollapsedByDefault(foldingDescriptor.getElement());
    }

    private static boolean mayUseBuilder(@NotNull ASTNode node, @Nullable FoldingBuilder builder) {
        if (builder == null) {
            return false;
        }
        if (DumbService.isDumbAware(builder)) {
            return true;
        }
        Project project = CompositeFoldingBuilder.getProjectByNode(node);
        return project == null || !DumbService.isDumb(project);
    }

    @Nullable
    private static Project getProjectByNode(@NotNull ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi == null) {
            ASTNode parent = node.getTreeParent();
            psi = parent == null ? null : parent.getPsi();
        }
        return psi == null ? null : psi.getProject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder foldingBuilder : this.myBuilders) {
            if (!DumbService.isDumbAware(foldingBuilder)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FoldingBuilder getOriginalBuilder(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor instanceof FoldingDescriptorWrapper) {
            return ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        }
        return null;
    }

    static class FoldingDescriptorWrapper
    extends FoldingDescriptor {
        @NotNull
        private final FoldingDescriptor myFoldingDescriptor;
        @NotNull
        private final FoldingBuilder myBuilder;

        FoldingDescriptorWrapper(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder builder) {
            super(foldingDescriptor.getElement(), foldingDescriptor.getRange(), foldingDescriptor.getGroup(), foldingDescriptor.getDependencies(), foldingDescriptor.isNonExpandable(), FoldingDescriptorWrapper.choosePlaceholderText(foldingDescriptor), foldingDescriptor.isCollapsedByDefault());
            this.myFoldingDescriptor = foldingDescriptor;
            this.myBuilder = builder;
        }

        private static String choosePlaceholderText(@NotNull FoldingDescriptor foldingDescriptor) {
            String cachedText = foldingDescriptor.getCachedPlaceholderText();
            String textFromGetText = foldingDescriptor.getPlaceholderText();
            boolean placeholderTextIsFallback = Objects.equals(textFromGetText, foldingDescriptor.getElement().getText());
            if (cachedText == null && placeholderTextIsFallback) {
                return null;
            }
            if (!placeholderTextIsFallback) {
                return textFromGetText;
            }
            return cachedText;
        }

        @Override
        @NotNull
        public Set<Object> getDependencies() {
            return this.myFoldingDescriptor.getDependencies();
        }

        @Override
        protected String calcPlaceholderText() {
            ASTNode element = this.getElement();
            return !CompositeFoldingBuilder.mayUseBuilder(element, this.myBuilder) ? element.getText() : (this.myBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)this.myBuilder).getPlaceholderText(element, this.getRange()) : this.myBuilder.getPlaceholderText(element));
        }

        @Override
        public boolean canBeRemovedWhenCollapsed() {
            return this.myFoldingDescriptor.canBeRemovedWhenCollapsed();
        }

        @Override
        public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
            this.myFoldingDescriptor.setCanBeRemovedWhenCollapsed(canBeRemovedWhenCollapsed);
        }
    }
}

