/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class MetaLanguage
extends Language {
    public static final ExtensionPointName<MetaLanguage> EP_NAME = new ExtensionPointName("com.intellij.metaLanguage");

    protected MetaLanguage(@NotNull String ID2) {
        super(ID2);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<MetaLanguage>(){

            public void extensionRemoved(@NotNull MetaLanguage metaLanguage, @NotNull PluginDescriptor pluginDescriptor) {
                if (MetaLanguage.this == metaLanguage) {
                    for (Language matchingLanguage : metaLanguage.getMatchingLanguages()) {
                        LanguageUtil.clearMatchingMetaLanguages(matchingLanguage);
                    }
                    Language.unregisterLanguage(metaLanguage);
                }
            }
        }, null);
    }

    @NotNull
    public static List<MetaLanguage> all() {
        return EP_NAME.getExtensionList();
    }

    public abstract boolean matchesLanguage(@NotNull Language var1);

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        return ContainerUtil.filter(Language.getRegisteredLanguages(), this::matchesLanguage);
    }
}

