/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LanguageImportStatements
extends LanguageExtension<ImportOptimizer> {
    public static final LanguageImportStatements INSTANCE = new LanguageImportStatements();

    private LanguageImportStatements() {
        super("com.intellij.lang.importOptimizer");
    }

    @NotNull
    public Set<ImportOptimizer> forFile(@NotNull PsiFile file) {
        CodeStyleSettings settings = CodeStyle.getSettings(file);
        if (settings.getExcludedFiles().contains(file)) {
            return Collections.emptySet();
        }
        HashSet<ImportOptimizer> optimizers = new HashSet<ImportOptimizer>();
        block0: for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            List langOptimizers = this.allForLanguage(psiFile.getLanguage());
            for (ImportOptimizer optimizer : langOptimizers) {
                if (optimizer == null || !optimizer.supports(psiFile)) continue;
                optimizers.add(optimizer);
                continue block0;
            }
        }
        return optimizers;
    }
}

