/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> myCacheKey;
    private final Key<List<T>> myAllCacheKey;

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        this(epName.getName(), null);
    }

    public LanguageExtension(@NotNull @NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName, @Nullable T defaultImplementation) {
        this(epName.getName(), defaultImplementation);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.myCacheKey = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
        this.myAllCacheKey = Key.create((String)("ALL_EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        return key.getID();
    }

    public void clearCache(@NotNull Language language) {
        this.clearCacheForDerivedLanguages(language);
        this.clearCache();
    }

    private void clearCacheForDerivedLanguages(@NotNull Language language) {
        Set<Language> languages = LanguageUtil.getAllDerivedLanguages(language);
        for (Language derivedLanguage : languages) {
            this.clearCacheForLanguage(derivedLanguage);
            Collection<MetaLanguage> metaLanguages = LanguageUtil.matchingMetaLanguages(derivedLanguage);
            for (MetaLanguage metaLanguage : metaLanguages) {
                this.clearCacheForLanguage(metaLanguage);
            }
        }
        if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            for (Language matchingLanguage : matchingLanguages) {
                Set<Language> matchingDerivedLanguages = LanguageUtil.getAllDerivedLanguages(matchingLanguage);
                for (Language derivedLanguage : matchingDerivedLanguages) {
                    this.clearCacheForLanguage(derivedLanguage);
                }
            }
        }
    }

    private void clearCacheForLanguage(Language language) {
        language.putUserData(this.myCacheKey, null);
        language.putUserData(this.myAllCacheKey, null);
        super.invalidateCacheForExtension(language.getID());
    }

    @Override
    public void invalidateCacheForExtension(String key) {
        super.invalidateCacheForExtension(key);
        Language language = Language.findLanguageByID(key);
        if (language != null) {
            this.clearCacheForDerivedLanguages(language);
        }
    }

    public T forLanguage(@NotNull Language l) {
        Object cached = l.getUserData(this.myCacheKey);
        if (cached != null) {
            return (T)cached;
        }
        Object result = this.findForLanguage(l);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.myCacheKey, result);
        return result;
    }

    protected T findForLanguage(@NotNull Language language) {
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        List cached = (List)language.getUserData(this.myAllCacheKey);
        if (cached != null) {
            return cached;
        }
        List<T> result = this.collectAllForLanguage(language);
        return (List)language.putUserDataIfAbsent(this.myAllCacheKey, result);
    }

    @NotNull
    private List<T> collectAllForLanguage(@NotNull Language language) {
        boolean copyList = true;
        List result = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List list = this.forKey(l);
            if (result == null) {
                result = list;
                continue;
            }
            if (list.isEmpty()) continue;
            if (copyList) {
                result = new ArrayList(ContainerUtil.concat(result, list));
                copyList = false;
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        Collection<MetaLanguage> metaLanguages = LanguageUtil.matchingMetaLanguages(key);
        if (metaLanguages.isEmpty()) {
            return super.buildExtensions(stringKey, key);
        }
        THashSet allKeys = new THashSet();
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        return this.buildExtensions((Set<String>)allKeys);
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        List<T> forLanguage = this.allForLanguage(l);
        if (l == Language.ANY) {
            return forLanguage;
        }
        return ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t) {
        this.clearCacheForLanguage(key);
        super.addExplicitExtension(key, t);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t) {
        this.clearCacheForLanguage(key);
        super.removeExplicitExtension(key, t);
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @Override
    protected void ensureValuesLoaded() {
        super.ensureValuesLoaded();
    }
}

