/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.CollectionComboBoxModel;
import java.util.Objects;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LafManager {
    public static LafManager getInstance() {
        return (LafManager)ApplicationManager.getApplication().getComponent(LafManager.class);
    }

    public abstract UIManager.LookAndFeelInfo @NotNull [] getInstalledLookAndFeels();

    @ApiStatus.Internal
    public abstract CollectionComboBoxModel<LafReference> getLafComboBoxModel();

    @ApiStatus.Internal
    public abstract UIManager.LookAndFeelInfo findLaf(LafReference var1);

    @Nullable
    public abstract UIManager.LookAndFeelInfo getCurrentLookAndFeel();

    @ApiStatus.Internal
    public abstract LafReference getCurrentLookAndFeelReference();

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo) {
        this.setCurrentLookAndFeel(lookAndFeelInfo, false);
    }

    public abstract void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo var1, boolean var2);

    public abstract void updateUI();

    public abstract void repaintUI();

    @Deprecated
    public abstract void addLafManagerListener(@NotNull LafManagerListener var1);

    @Deprecated
    public abstract void addLafManagerListener(@NotNull LafManagerListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeLafManagerListener(@NotNull LafManagerListener var1);

    public static class LafReference {
        private final String name;
        private final String className;
        private final String themeId;

        public LafReference(@NotNull String name, @NotNull String className, @Nullable String themeId) {
            this.name = name;
            this.className = className;
            this.themeId = themeId;
        }

        public String toString() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getThemeId() {
            return this.themeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LafReference reference = (LafReference)o;
            return this.name.equals(reference.name) && this.className.equals(reference.className) && Objects.equals(this.themeId, reference.themeId);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.className, this.themeId);
        }
    }
}

