/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEdit {
    private LightEdit() {
    }

    @Contract(value="null -> false")
    public static boolean owns(@Nullable Project project) {
        return project instanceof LightEditCompatible;
    }

    public static boolean openFile(@NotNull VirtualFile file) {
        return LightEditService.getInstance().openFile(file, false);
    }

    public static boolean isActionCompatible(@NotNull AnAction action) {
        return action instanceof ActionGroup && action.isDumbAware() || action instanceof LightEditCompatible;
    }
}

