/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.pom.Navigatable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffElement<T> {
    public static final DiffElement<?>[] EMPTY_ARRAY = new DiffElement[0];

    public abstract String getPath();

    @NotNull
    public abstract String getName();

    public String getPresentableName() {
        return this.getName();
    }

    public String getPresentablePath() {
        return this.getPresentableName();
    }

    public abstract long getSize();

    public abstract long getTimeStamp();

    public FileType getFileType() {
        return FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
    }

    public abstract boolean isContainer();

    public abstract DiffElement[] getChildren() throws IOException;

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        return null;
    }

    public abstract byte @Nullable [] getContent() throws IOException;

    @Nullable
    public InputStream getContentStream() throws IOException {
        byte[] bytes = this.getContent();
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @NotNull
    public Charset getCharset() {
        return EncodingManager.getInstance().getDefaultCharset();
    }

    public abstract T getValue();

    public static String getSeparator() {
        return "/";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        try {
            T src = this.getValue();
            if (src instanceof VirtualFile) {
                return DiffContentFactory.getInstance().create(project, (VirtualFile)src);
            }
            byte[] content = this.getContent();
            if (content == null) {
                throw new DiffRequestProducerException("Can't get content");
            }
            return DiffContentFactory.getInstance().create(project, new String(content, this.getCharset()), this.getFileType());
        }
        catch (IOException e) {
            throw new DiffRequestProducerException(e);
        }
    }

    @Nullable
    public Callable<DiffElement<T>> getElementChooser(@Nullable Project project) {
        return null;
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @Nullable
    public DiffElement<?> copyTo(DiffElement<T> container, String relativePath) {
        return null;
    }

    public boolean delete() {
        return false;
    }

    public void refresh(boolean userInitiated) throws IOException {
    }
}

