/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettingsConfigurable;
import com.intellij.ide.browsers.firefox.FirefoxUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FirefoxSettings
extends BrowserSpecificSettings {
    private String myProfilesIniPath;
    private String myProfile;

    public FirefoxSettings() {
    }

    public FirefoxSettings(@Nullable String profilesIniPath, @Nullable String profile) {
        this.myProfilesIniPath = StringUtil.nullize((String)profilesIniPath);
        this.myProfile = StringUtil.nullize((String)profile);
    }

    @Tag(value="profiles-ini-path")
    @Nullable
    public String getProfilesIniPath() {
        return this.myProfilesIniPath;
    }

    public void setProfilesIniPath(@Nullable String value) {
        this.myProfilesIniPath = PathUtil.toSystemIndependentName(StringUtil.nullize((String)value));
    }

    @Tag(value="profile")
    @Nullable
    public String getProfile() {
        return this.myProfile;
    }

    public void setProfile(@Nullable String value) {
        this.myProfile = StringUtil.nullize((String)value);
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        return new FirefoxSettingsConfigurable(this);
    }

    @Nullable
    public File getProfilesIniFile() {
        if (this.myProfilesIniPath != null) {
            return new File(FileUtil.toSystemDependentName((String)this.myProfilesIniPath));
        }
        return FirefoxUtil.getDefaultProfileIniPath();
    }

    @Override
    @NotNull
    public List<String> getAdditionalParameters() {
        FirefoxProfile profile;
        List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(this.getProfilesIniFile());
        if (profiles.size() >= 2 && (profile = FirefoxUtil.findProfileByNameOrDefault(this.myProfile, profiles)) != null && !profile.isDefault()) {
            return Arrays.asList("-P", profile.getName());
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirefoxSettings settings = (FirefoxSettings)o;
        return Objects.equals(this.myProfilesIniPath, settings.myProfilesIniPath) && Objects.equals(this.myProfile, settings.myProfile);
    }
}

