/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SelectInManager {
    private final Project myProject;
    private final SimpleSmartExtensionPoint<SelectInTarget> myTargets;
    @Deprecated
    @NonNls
    public static final String PROJECT = SelectInManager.getProject();

    public SelectInManager(@NotNull Project project) {
        this.myProject = project;
        this.myTargets = SimpleSmartExtensionPoint.create((ExtensionsArea)this.myProject.getExtensionArea(), SelectInTarget.EP_NAME);
    }

    @Deprecated
    public void addTarget(SelectInTarget target) {
        this.myTargets.addExplicitExtension((Object)target);
    }

    public void removeTarget(SelectInTarget target) {
        this.myTargets.removeExplicitExtension((Object)target);
    }

    @NotNull
    public List<SelectInTarget> getTargetList() {
        ArrayList<SelectInTarget> targets = new ArrayList<SelectInTarget>(this.myTargets.getExtensions());
        if (DumbService.getInstance(this.myProject).isDumb()) {
            targets.removeIf(target -> !DumbService.isDumbAware(target));
        }
        targets.sort(SelectInTargetComparator.INSTANCE);
        return targets;
    }

    public SelectInTarget @NotNull [] getTargets() {
        return this.getTargetList().toArray(new SelectInTarget[0]);
    }

    public static SelectInManager getInstance(@NotNull Project project) {
        return (SelectInManager)project.getService(SelectInManager.class);
    }

    public static SelectInTarget findSelectInTarget(@NotNull String id, Project project) {
        List<SelectInTarget> targets;
        SelectInManager manager = project == null || project.isDisposed() ? null : SelectInManager.getInstance(project);
        List<SelectInTarget> list = targets = manager == null ? null : manager.getTargetList();
        if (targets != null) {
            for (SelectInTarget target : targets) {
                if (target == null || !Objects.equals(id, target.getToolWindowId())) continue;
                return target;
            }
        }
        return null;
    }

    public static String getProject() {
        return IdeBundle.message("select.in.project", new Object[0]);
    }

    public static String getPackages() {
        return IdeBundle.message("select.in.packages", new Object[0]);
    }

    public static String getCommander() {
        return IdeBundle.message("select.in.commander", new Object[0]);
    }

    public static String getFavorites() {
        return IdeBundle.message("select.in.favorites", new Object[0]);
    }

    public static String getNavBar() {
        return IdeBundle.message("select.in.nav.bar", new Object[0]);
    }

    public static String getScope() {
        return IdeBundle.message("select.in.scope", new Object[0]);
    }

    public static class SelectInTargetComparator
    implements Comparator<SelectInTarget> {
        public static final Comparator<SelectInTarget> INSTANCE = new SelectInTargetComparator();

        @Override
        public int compare(SelectInTarget o1, SelectInTarget o2) {
            return Float.compare(o1.getWeight(), o2.getWeight());
        }
    }
}

