/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Formatter;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Spacing {
    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        return Formatter.getInstance().createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines);
    }

    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        return Formatter.getInstance().createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines, prefLineFeeds);
    }

    public static Spacing getReadOnlySpacing() {
        return Formatter.getInstance().getReadOnlySpacing();
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines) {
        return Spacing.createDependentLFSpacing(minSpaces, maxSpaces, dependency, keepLineBreaks, keepBlankLines, DependentSpacingRule.DEFAULT);
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependency, boolean keepLineBreaks, int keepBlankLines) {
        return Formatter.getInstance().createDependentLFSpacing(minSpaces, maxSpaces, dependency, keepLineBreaks, keepBlankLines, DependentSpacingRule.DEFAULT);
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependencyRange, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        return Formatter.getInstance().createDependentLFSpacing(minSpaces, maxSpaces, dependencyRange, keepLineBreaks, keepBlankLines, rule);
    }

    public static Spacing createSafeSpacing(boolean keepLineBreaks, int keepBlankLines) {
        return Formatter.getInstance().createSafeSpacing(keepLineBreaks, keepBlankLines);
    }

    public static Spacing createKeepingFirstColumnSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
        return Formatter.getInstance().createKeepingFirstColumnSpacing(minSpaces, maxSpaces, keepLineBreaks, keepBlankLines);
    }
}

