/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.facet.frameworks.beans.Artifacts;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibrariesDownloadAssistant {
    private static final Logger LOG = Logger.getInstance(LibrariesDownloadAssistant.class);

    private LibrariesDownloadAssistant() {
    }

    public static Artifact @NotNull [] getVersions(@NotNull String groupId, URL ... localUrls) {
        Artifact[] versions = !ApplicationManager.getApplication().isUnitTestMode() ? LibrariesDownloadAssistant.getDownloadServiceVersions(groupId) : null;
        return versions == null ? LibrariesDownloadAssistant.getVersions(localUrls) : versions;
    }

    private static Artifact @Nullable [] getDownloadServiceVersions(@NotNull String id) {
        URL url = LibrariesDownloadAssistant.createVersionsUrl(id);
        if (url == null) {
            return null;
        }
        Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
        return allArtifacts == null ? null : allArtifacts.getArtifacts();
    }

    @Nullable
    private static URL createVersionsUrl(@NotNull String id) {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + id + "/";
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Artifact @NotNull [] getVersions(URL ... urls) {
        HashSet<Artifact> versions = new HashSet<Artifact>();
        for (URL url : urls) {
            Artifact[] vers;
            Artifacts allArtifacts = LibrariesDownloadAssistant.deserialize(url);
            if (allArtifacts == null || (vers = allArtifacts.getArtifacts()) == null) continue;
            versions.addAll(Arrays.asList(vers));
        }
        return versions.toArray(Artifact.EMPTY_ARRAY);
    }

    @Nullable
    private static Artifacts deserialize(@Nullable URL url) {
        Artifacts allArtifacts;
        block3: {
            if (url == null) {
                return null;
            }
            allArtifacts = null;
            try {
                allArtifacts = (Artifacts)XmlSerializer.deserialize((URL)url, Artifacts.class);
            }
            catch (SerializationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) break block3;
                LOG.error((Throwable)e);
            }
        }
        return allArtifacts;
    }

    @Nullable
    public static Artifact findVersion(@NotNull String versionId, URL ... urls) {
        return LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(urls), versionId);
    }

    @Nullable
    private static Artifact findVersion(Artifact @Nullable [] versions, @NotNull String versionId) {
        return versions == null ? null : (Artifact)ContainerUtil.find((Object[])versions, springVersion -> versionId.equals(springVersion.getVersion()));
    }

    public static LibraryInfo @NotNull [] getLibraryInfos(@NotNull URL url, @NotNull String versionId) {
        Artifact version = LibrariesDownloadAssistant.findVersion(LibrariesDownloadAssistant.getVersions(url), versionId);
        return version != null ? LibrariesDownloadAssistant.getLibraryInfos(version) : LibraryInfo.EMPTY_ARRAY;
    }

    public static LibraryInfo @NotNull [] getLibraryInfos(@Nullable Artifact version) {
        if (version == null) {
            return LibraryInfo.EMPTY_ARRAY;
        }
        List<LibraryInfo> infos = LibrariesDownloadAssistant.convert(version.getUrlPrefix(), version.getItems());
        return infos.toArray(LibraryInfo.EMPTY_ARRAY);
    }

    @NotNull
    private static List<LibraryInfo> convert(String urlPrefix, ArtifactItem @NotNull [] jars) {
        return ContainerUtil.mapNotNull((Object[])jars, artifactItem -> {
            String downloadUrl = artifactItem.getUrl();
            if (urlPrefix != null) {
                if (downloadUrl == null) {
                    downloadUrl = artifactItem.getName();
                }
                if (!downloadUrl.startsWith("http://")) {
                    downloadUrl = urlPrefix + downloadUrl;
                }
            }
            return new LibraryInfo(artifactItem.getName(), downloadUrl, downloadUrl, artifactItem.getMD5(), artifactItem.getRequiredClasses());
        });
    }
}

