/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.value.CompositeTargetValue;
import com.intellij.execution.target.value.FixedTargetValue;
import com.intellij.execution.target.value.MapTargetValue;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public interface TargetValue<T> {
    public static final TargetValue EMPTY_VALUE = new TargetValue(){

        public Promise<Object> getLocalValue() {
            return Promises.resolvedPromise();
        }

        public Promise<Object> getTargetValue() {
            return Promises.resolvedPromise();
        }
    };

    public Promise<T> getLocalValue();

    public Promise<T> getTargetValue();

    public static <V> TargetValue<V> empty() {
        return EMPTY_VALUE;
    }

    public static <V> TargetValue<V> fixed(V value) {
        return new FixedTargetValue<V>(value);
    }

    public static <T, V> TargetValue<V> map(@NotNull TargetValue<? extends T> originalValue, @NotNull Function<T, ? extends V> mapper) {
        return new MapTargetValue<T, V>(originalValue, mapper);
    }

    public static <T, V> TargetValue<V> composite(@NotNull Collection<TargetValue<T>> values, @NotNull Function<Collection<T>, ? extends V> joiner) {
        return new CompositeTargetValue(values, joiner);
    }
}

