/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.pom.Navigatable;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ServiceViewDescriptor {
    @NotNull
    public ItemPresentation getPresentation();

    @Nullable
    default public String getId() {
        return this.getPresentation().getPresentableText();
    }

    @Nullable
    default public JComponent getContentComponent() {
        return null;
    }

    @NotNull
    default public ItemPresentation getContentPresentation() {
        return this.getPresentation();
    }

    @NotNull
    default public ItemPresentation getCustomPresentation(@NotNull ServiceViewOptions options) {
        return this.getPresentation();
    }

    @Nullable
    default public ActionGroup getToolbarActions() {
        return null;
    }

    @Nullable
    default public ActionGroup getPopupActions() {
        return this.getToolbarActions();
    }

    @Nullable
    default public DataProvider getDataProvider() {
        return null;
    }

    default public void onNodeSelected() {
    }

    default public void onNodeUnselected() {
    }

    default public boolean handleDoubleClick(@NotNull MouseEvent event) {
        Navigatable navigatable = this.getNavigatable();
        if (navigatable != null && navigatable.canNavigateToSource()) {
            navigatable.navigate(true);
            return true;
        }
        return false;
    }

    @Nullable
    default public Object getPresentationTag(Object fragment) {
        return null;
    }

    @Nullable
    default public Navigatable getNavigatable() {
        return null;
    }

    @Nullable
    default public Runnable getRemover() {
        return null;
    }

    default public boolean isVisible() {
        return true;
    }
}

