/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SettingsEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProgramRunner<Settings extends RunnerSettings> {
    public static final ExtensionPointName<ProgramRunner<? extends RunnerSettings>> PROGRAM_RUNNER_EP = new ExtensionPointName("com.intellij.programRunner");

    @Nullable
    public static ProgramRunner<?> findRunnerById(@NotNull String id) {
        return (ProgramRunner)PROGRAM_RUNNER_EP.findFirstSafe(it -> id.equals(it.getRunnerId()));
    }

    @Nullable
    public static ProgramRunner<RunnerSettings> getRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        return (ProgramRunner)PROGRAM_RUNNER_EP.findFirstSafe(it -> it.canRun(executorId, settings));
    }

    @NotNull
    @NonNls
    public String getRunnerId();

    public boolean canRun(@NotNull String var1, @NotNull RunProfile var2);

    @Nullable
    default public Settings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        return null;
    }

    default public void checkConfiguration(RunnerSettings settings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    @Deprecated
    default public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    @Nullable
    default public SettingsEditor<Settings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    public void execute(@NotNull ExecutionEnvironment var1) throws ExecutionException;

    @Deprecated
    default public void execute(@NotNull ExecutionEnvironment environment, @Nullable Callback callback) throws ExecutionException {
        if (callback != null) {
            environment.setCallback(callback);
        }
        this.execute(environment);
    }

    public static interface Callback {
        public void processStarted(RunContentDescriptor var1);
    }
}

