/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocatableConfigurationBase<T>
extends RunConfigurationBase<T>
implements LocatableConfiguration {
    protected LocatableConfigurationBase(@NotNull Project project, @NotNull ConfigurationFactory factory, @Nullable String name) {
        super(project, factory, name);
    }

    protected LocatableConfigurationBase(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        super(project, factory, null);
    }

    @Override
    @NotNull
    protected LocatableRunConfigurationOptions getOptions() {
        return (LocatableRunConfigurationOptions)super.getOptions();
    }

    @Override
    @NotNull
    protected Class<? extends LocatableRunConfigurationOptions> getDefaultOptionsClass() {
        return LocatableRunConfigurationOptions.class;
    }

    @Override
    @Attribute(value="nameIsGenerated")
    public boolean isGeneratedName() {
        return this.getOptions().isNameGenerated() && this.suggestedName() != null;
    }

    public void setGeneratedName() {
        this.setName(StringUtilRt.notNullize((String)this.suggestedName()));
        this.getOptions().setNameGenerated(true);
    }

    public void setNameChangedByUser(boolean nameChangedByUser) {
        this.getOptions().setNameGenerated(!nameChangedByUser);
    }

    @Nullable
    public String getActionName() {
        String name = this.getName();
        String shortName = name.length() < 20 ? name : name.substring(0, 20) + "...";
        return shortName + this.getPresentableType();
    }
}

