/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    public static final InspectionToolWrapper[] EMPTY_ARRAY = new InspectionToolWrapper[0];
    private static final Logger LOG = Logger.getInstance(InspectionToolWrapper.class);
    protected T myTool;
    protected final E myEP;
    @Nullable
    private HighlightDisplayKey myDisplayKey;

    protected InspectionToolWrapper(@NotNull E ep) {
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, ? extends E> other) {
        this.myEP = other.myEP;
        this.myTool = other.myTool == null ? null : (this.myEP == null ? (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass()) : ((InspectionEP)this.myEP).instantiateTool());
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        ((InspectionProfileEntry)this.getTool()).initialize(context);
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error((Throwable)new PluginException("Short name not matched for " + tool.getClass() + ": getShortName() = #" + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = #" + ((InspectionEP)this.myEP).getShortName(), ((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginId()));
            }
        }
        return tool;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? null : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        String langId = this.getLanguage();
        return this.isApplicable(language, langId);
    }

    private boolean isApplicable(@NotNull Language language, String toolLang) {
        if (toolLang == null) {
            return true;
        }
        if (language.getID().equals(toolLang)) {
            return true;
        }
        if (this.applyToDialects()) {
            if (language.isKindOf(toolLang)) {
                return true;
            }
            Language toolLanguage = Language.findLanguageByID(toolLang);
            if (toolLanguage instanceof MetaLanguage) {
                for (Language lang : ((MetaLanguage)toolLanguage).getMatchingLanguages()) {
                    if (!this.isApplicable(language, lang.getID())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        return this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
    }

    public String getID() {
        return this.getShortName();
    }

    @NotNull
    public String getDisplayName() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getDisplayName();
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        return name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
    }

    @NotNull
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        return groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
    }

    public String @NotNull [] getGroupPath() {
        if (this.myEP == null) {
            return ((InspectionProfileEntry)this.getTool()).getGroupPath();
        }
        String[] path2 = ((InspectionEP)this.myEP).getGroupPath();
        return path2 == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path2;
    }

    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = this.getDescriptionStream();
            return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    private InputStream getDescriptionStream() {
        Application app = ApplicationManager.getApplication();
        String fileName = this.getDescriptionFileName();
        if (this.myEP == null || app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return ResourceUtil.getResourceAsStream((ClassLoader)this.getDescriptionContextClass().getClassLoader(), (String)"inspectionDescriptions", (String)fileName);
        }
        return ((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginClassLoader().getResourceAsStream("inspectionDescriptions/" + fileName);
    }

    @NotNull
    private String getDescriptionFileName() {
        return this.getShortName() + ".html";
    }

    @NotNull
    public final String getFolderName() {
        return this.getShortName();
    }

    @NotNull
    public Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getTool().getClass();
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        T tool = this.myTool;
        if (tool != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    public abstract JobDescriptor @NotNull [] getJobDescriptors(@NotNull GlobalInspectionContext var1);

    public HighlightDisplayKey getDisplayKey() {
        HighlightDisplayKey key = this.myDisplayKey;
        if (key == null) {
            this.myDisplayKey = key = HighlightDisplayKey.find(this.getShortName());
        }
        return key;
    }
}

