/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateActionContext {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myIsSurrounding;

    private TemplateActionContext(@NotNull PsiFile file, @Nullable Editor editor, int startOffset, int endOffset, boolean isSurrounding) {
        this.myFile = file;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myIsSurrounding = isSurrounding;
        this.myEditor = editor;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @ApiStatus.Internal
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public boolean isSurrounding() {
        return this.myIsSurrounding;
    }

    @NotNull
    public TemplateActionContext withFile(@NotNull PsiFile file) {
        return new TemplateActionContext(file, this.myEditor, this.myStartOffset, this.myEndOffset, this.myIsSurrounding);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        int editorOffset = editor.getCaretModel().getOffset();
        return TemplateActionContext.create(psiFile, editor, editorOffset, editorOffset, false);
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, int offset) {
        return TemplateActionContext.create(psiFile, null, offset, offset, false);
    }

    @NotNull
    public static TemplateActionContext surrounding(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return TemplateActionContext.create(psiFile, editor, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), true);
    }

    @NotNull
    public static TemplateActionContext create(@NotNull PsiFile psiFile, @Nullable Editor editor, int startOffset, int endOffset, boolean isSurrounding) {
        return new TemplateActionContext(psiFile, editor, startOffset, endOffset, isSurrounding);
    }
}

