/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementBaseIntentionAction
extends BaseIntentionAction {
    @Override
    public final void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (editor == null || !this.checkFile(file)) {
            return;
        }
        PsiElement element = PsiElementBaseIntentionAction.getElement(editor, file);
        if (element != null) {
            this.invoke(project, editor, element);
        }
    }

    public boolean checkFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        return PsiElementBaseIntentionAction.canModify(file);
    }

    public abstract void invoke(@NotNull Project var1, Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;

    @Override
    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.checkFile(file)) {
            return false;
        }
        PsiElement element = editor == null ? null : PsiElementBaseIntentionAction.getElement(editor, file);
        return element != null && this.isAvailable(project, editor, element);
    }

    public abstract boolean isAvailable(@NotNull Project var1, Editor var2, @NotNull PsiElement var3);

    @Nullable
    private static PsiElement getElement(@NotNull Editor editor, @NotNull PsiFile file) {
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        return file.findElementAt(position);
    }
}

