/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.codeInsight.completion.TemplateParameterTraversalPolicy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NextPrevParameterAction
extends CodeInsightAction
implements DumbAware {
    private static final LanguageExtension<TemplateParameterTraversalPolicy> EP = new LanguageExtension("com.intellij.templateParameterTraversalPolicy");
    private final boolean myNext;

    protected NextPrevParameterAction(boolean next) {
        this.myNext = next;
    }

    @Override
    @NotNull
    public CodeInsightActionHandler getHandler() {
        return new Handler();
    }

    @Override
    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return NextPrevParameterAction.hasSuitablePolicy(editor, file);
    }

    public static boolean hasSuitablePolicy(Editor editor, PsiFile file) {
        return NextPrevParameterAction.findSuitableTraversalPolicy(editor, file) != null;
    }

    @Override
    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        PsiFile file = e.getData(CommonDataKeys.PSI_FILE);
        if (file != null && NextPrevParameterAction.findPolicyForFile(file) != null) {
            CodeInsightEditorAction.beforeActionPerformedUpdate(e);
        }
        this.update(e);
    }

    @Nullable
    private static TemplateParameterTraversalPolicy findSuitableTraversalPolicy(Editor editor, PsiFile file) {
        TemplateParameterTraversalPolicy policy = NextPrevParameterAction.findPolicyForFile(file);
        return policy != null && policy.isValidForFile(editor, file) ? policy : null;
    }

    private static TemplateParameterTraversalPolicy findPolicyForFile(PsiFile file) {
        return EP.forLanguage(file.getLanguage());
    }

    public static class Prev
    extends NextPrevParameterAction {
        public Prev() {
            super(false);
        }
    }

    public static class Next
    extends NextPrevParameterAction {
        public Next() {
            super(true);
        }
    }

    private class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            TemplateParameterTraversalPolicy policy = NextPrevParameterAction.findSuitableTraversalPolicy(editor, file);
            if (policy != null) {
                policy.invoke(editor, file, NextPrevParameterAction.this.myNext);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }
}

