/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SourceInfo;

public final class PsiVisitors {
    public static <RESULT> RESULT visit(@NotNull XSourcePosition position, @NotNull Project project, @NotNull Visitor<RESULT> visitor) {
        return PsiVisitors.visit(position, project, visitor, null);
    }

    public static <RESULT> RESULT visit(@NotNull XSourcePosition position, @NotNull Project project, @NotNull Visitor<? extends RESULT> visitor, RESULT defaultResult) {
        return (RESULT)ReadAction.compute(() -> {
            int positionOffset;
            PsiFile file2;
            Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
            PsiFile psiFile = file2 = document == null || document.getTextLength() == 0 ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file2 == null) {
                return defaultResult;
            }
            int column = position instanceof SourceInfo ? Math.max(((SourceInfo)position).getColumn(), 0) : 0;
            try {
                positionOffset = column == 0 ? DocumentUtil.getFirstNonSpaceCharOffset(document, position.getLine()) : document.getLineStartOffset(position.getLine()) + column;
            }
            catch (IndexOutOfBoundsException ignored) {
                return defaultResult;
            }
            PsiElement element2 = file2.findElementAt(positionOffset);
            return element2 == null ? defaultResult : visitor.visit(position, element2, positionOffset, document);
        });
    }

    public static abstract class FilteringPsiRecursiveElementWalkingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        public void visitElement(@NotNull PsiElement element2) {
            if (!(element2 instanceof ForeignLeafPsiElement) && element2.isPhysical()) {
                super.visitElement(element2);
            }
        }

        public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        }

        public void visitComment(@NotNull PsiComment comment) {
        }

        public void visitOuterLanguageElement(@NotNull OuterLanguageElement element2) {
        }
    }

    public static interface Visitor<RESULT> {
        public RESULT visit(@NotNull XSourcePosition var1, @NotNull PsiElement var2, int var3, @NotNull Document var4);
    }
}

