/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final String myTitle;
    private final String myGroupStart;

    GroupSurrounder(@Nls String title, String groupStart) {
        this.myTitle = title;
        this.myGroupStart = groupStart;
    }

    public String getTemplateDescription() {
        return this.myTitle;
    }

    public boolean isApplicable(PsiElement @NotNull [] elements2) {
        return elements2.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements2) == elements2[0].getParent();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements2) throws IncorrectOperationException {
        assert (elements2.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements2) == elements2[0].getParent());
        PsiElement e = elements2[0];
        ASTNode node = e.getNode();
        assert (node != null);
        ASTNode parent = node.getTreeParent();
        StringBuilder s = new StringBuilder();
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            PsiElement element2 = elements2[i2];
            if (element2 instanceof RegExpElementImpl) {
                s.append(((RegExpElementImpl)element2).getUnescapedText());
            } else {
                s.append(element2.getText());
            }
            if (i2 <= 0) continue;
            ASTNode child2 = element2.getNode();
            assert (child2 != null);
            parent.removeChild(child2);
        }
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project);
        PsiFile f = factory2.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s));
        RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
        assert (pattern != null);
        RegExpAtom element3 = pattern.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e)) {
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
            TextRange tr = e.getTextRange();
            doc.replaceString(tr.getStartOffset(), tr.getEndOffset(), (CharSequence)StringUtil.escapeStringCharacters((String)element3.getText()));
            return TextRange.from((int)e.getTextRange().getEndOffset(), (int)0);
        }
        PsiElement n = e.replace((PsiElement)element3);
        return TextRange.from((int)n.getTextRange().getEndOffset(), (int)0);
    }

    private static boolean isInsideStringLiteral(PsiElement context) {
        while (context != null) {
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return true;
            }
            context = context.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s) {
        return this.myGroupStart + s + ")";
    }
}

