/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpBoundaryImpl
extends RegExpElementImpl
implements RegExpBoundary {
    public RegExpBoundaryImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpBoundary.Type getType() {
        IElementType type = this.getNode().getFirstChildNode().getElementType();
        if (type == RegExpTT.CARET) {
            return RegExpBoundary.Type.LINE_START;
        }
        if (type == RegExpTT.DOLLAR) {
            return RegExpBoundary.Type.LINE_END;
        }
        if (type == RegExpTT.BOUNDARY) {
            String s = this.getUnescapedText();
            if (s.equals("\\b")) {
                return RegExpBoundary.Type.WORD;
            }
            if (s.equals("\\b{g}")) {
                return RegExpBoundary.Type.UNICODE_EXTENDED_GRAPHEME;
            }
            if (s.equals("\\B")) {
                return RegExpBoundary.Type.NON_WORD;
            }
            if (s.equals("\\A")) {
                return RegExpBoundary.Type.BEGIN;
            }
            if (s.equals("\\Z")) {
                return RegExpBoundary.Type.END_NO_LINE_TERM;
            }
            if (s.equals("\\z")) {
                return RegExpBoundary.Type.END;
            }
            if (s.equals("\\G")) {
                return RegExpBoundary.Type.PREVIOUS_MATCH;
            }
            if (s.equals("\\K")) {
                return RegExpBoundary.Type.RESET_MATCH;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpBoundary(this);
    }
}

