/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpBackrefImpl
extends RegExpElementImpl
implements RegExpBackref {
    public RegExpBackrefImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public int getIndex() {
        return Integer.parseInt(this.getIndexNumberText());
    }

    @NotNull
    private String getIndexNumberText() {
        String s = this.getUnescapedText();
        assert (s.charAt(0) == '\\');
        boolean pcreBackReference = s.charAt(1) == 'g';
        return pcreBackReference ? RegExpBackrefImpl.getPcreBackrefIndexNumberText(s.substring(2)) : s.substring(1);
    }

    @NotNull
    private static String getPcreBackrefIndexNumberText(String s) {
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)s, (String)"{"), (String)"}");
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpBackref(this);
    }

    @Override
    public RegExpGroup resolve() {
        int index = this.getIndex();
        if (index < 0) {
            return this.resolveRelativeGroup(Math.abs(index));
        }
        return (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)this.getContainingFile()).traverse().takeWhile(e -> e != this).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).skip(index - 1).first();
    }

    @Nullable
    private RegExpGroup resolveRelativeGroup(int index) {
        List groups = SyntaxTraverser.psiTraverser((PsiElement)this.getContainingFile()).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).toList();
        return index <= groups.size() ? (RegExpGroup)groups.get(groups.size() - index) : null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @NotNull
            public PsiElement getElement() {
                return RegExpBackrefImpl.this;
            }

            @NotNull
            public TextRange getRangeInElement() {
                return TextRange.from((int)0, (int)this.getElement().getTextLength());
            }

            @NotNull
            public String getCanonicalText() {
                return this.getElement().getText();
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                throw new IncorrectOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                throw new IncorrectOperationException();
            }

            public boolean isReferenceTo(@NotNull PsiElement element2) {
                return Comparing.equal((Object)element2, (Object)this.resolve());
            }

            public boolean isSoft() {
                return false;
            }

            public PsiElement resolve() {
                return RegExpBackrefImpl.this.resolve();
            }
        };
    }
}

