/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileBreadcrumbsCollector
extends FileBreadcrumbsCollector {
    private static final Logger LOG = Logger.getInstance(PsiFileBreadcrumbsCollector.class);
    private final Project myProject;

    public PsiFileBreadcrumbsCollector(Project project) {
        this.myProject = project;
    }

    public boolean handlesFile(@NotNull VirtualFile virtualFile) {
        return true;
    }

    public boolean isShownForFile(@NotNull Editor editor, @NotNull VirtualFile file2) {
        return BreadcrumbsUtilEx.findProvider(file2, editor.getProject(), BreadcrumbsForceShownSettings.getForcedShown(editor)) != null;
    }

    public void watchForChanges(final @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull Disposable disposable2, final @NotNull Runnable changesHandler) {
        PomManager.getModel((Project)this.myProject).addModelListener(new PomModelListener(){

            public void modelChanged(@NotNull PomModelEvent event) {
                VirtualFile changedFile;
                TreeAspect aspect = (TreeAspect)ContainerUtil.findInstance((Iterable)event.getChangedAspects(), TreeAspect.class);
                if (aspect == null) {
                    return;
                }
                TreeChangeEvent change = (TreeChangeEvent)ObjectUtils.tryCast((Object)event.getChangeSet((PomModelAspect)aspect), TreeChangeEvent.class);
                if (change == null) {
                    return;
                }
                PsiFile psiFile = change.getRootElement().getPsi().getContainingFile();
                VirtualFile virtualFile = changedFile = psiFile == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)changedFile, (Object)file2)) {
                    return;
                }
                changesHandler.run();
            }

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                return aspect instanceof TreeAspect;
            }
        }, disposable2);
    }

    @NotNull
    public Iterable<Crumb> computeCrumbs(@NotNull VirtualFile file2, @NotNull Document document, int offset, Boolean forcedShown) {
        BreadcrumbsProvider defaultInfoProvider = BreadcrumbsUtilEx.findProvider(file2, this.myProject, forcedShown);
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = PsiFileBreadcrumbsCollector.getLineElements(document, offset, file2, this.myProject, defaultInfoProvider, true);
        if (pairs == null) {
            return Collections.emptyList();
        }
        ArrayList<Crumb> result2 = new ArrayList<Crumb>(pairs.size());
        CrumbPresentation[] presentations = PsiFileBreadcrumbsCollector.getCrumbPresentations(PsiFileBreadcrumbsCollector.toPsiElementArray(pairs));
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            CrumbPresentation presentation2 = null;
            if (presentations != null && 0 <= index && index < presentations.length) {
                presentation2 = presentations[index++];
            }
            result2.add((Crumb)new PsiCrumb((PsiElement)pair.first, (BreadcrumbsProvider)pair.second, presentation2));
        }
        return result2;
    }

    private static CrumbPresentation @Nullable [] getCrumbPresentations(PsiElement[] elements2) {
        for (BreadcrumbsPresentationProvider provider : BreadcrumbsPresentationProvider.EP_NAME.getExtensionList()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements2);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    @Nullable
    private static Collection<Pair<PsiElement, BreadcrumbsProvider>> getLineElements(Document document, int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        PsiElement element2 = PsiFileBreadcrumbsCollector.findStartElement(document, offset, file2, project, defaultInfoProvider, checkSettings);
        if (element2 == null) {
            return null;
        }
        LinkedList<Pair<PsiElement, BreadcrumbsProvider>> result2 = new LinkedList<Pair<PsiElement, BreadcrumbsProvider>>();
        while (element2 != null) {
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element2, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptElement(element2)) {
                result2.addFirst((Pair<PsiElement, BreadcrumbsProvider>)Pair.create((Object)element2, (Object)provider));
            }
            if (!((element2 = PsiFileBreadcrumbsCollector.getParent(element2, provider)) instanceof PsiDirectory)) continue;
            break;
        }
        return result2;
    }

    @Nullable
    private static PsiElement findStartElement(Document document, int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        PsiElement middleElement = PsiFileBreadcrumbsCollector.findFirstBreadcrumbedElement(offset, file2, project, defaultInfoProvider, checkSettings);
        CharSequence chars = document.getCharsSequence();
        int leftOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ");
        leftOffset = leftOffset >= 0 ? leftOffset : offset - 1;
        PsiElement leftElement = PsiFileBreadcrumbsCollector.findFirstBreadcrumbedElement(leftOffset, file2, project, defaultInfoProvider, checkSettings);
        if (leftElement != null && (middleElement == null || PsiTreeUtil.isAncestor((PsiElement)middleElement, (PsiElement)leftElement, (boolean)true))) {
            return leftElement;
        }
        return middleElement;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        if (file2 == null || !file2.isValid() || file2.isDirectory()) {
            return null;
        }
        PriorityQueue leafs = new PriorityQueue(3, (o1, o2) -> {
            TextRange range1 = o1.getTextRange();
            if (range1 == null) {
                LOG.error(o1 + " returned null range");
                return 1;
            }
            TextRange range2 = o2.getTextRange();
            if (range2 == null) {
                LOG.error(o2 + " returned null range");
                return -1;
            }
            return range2.getStartOffset() - range1.getStartOffset();
        });
        FileViewProvider viewProvider = BreadcrumbsUtilEx.findViewProvider(file2, project);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull(leafs, (Object)viewProvider.findElementAt(offset, language));
        }
        while (!leafs.isEmpty()) {
            PsiElement element2 = (PsiElement)leafs.remove();
            if (!element2.isValid()) continue;
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element2, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptElement(element2)) {
                return element2;
            }
            if (element2 instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull(leafs, (Object)PsiFileBreadcrumbsCollector.getParent(element2, provider));
        }
        return null;
    }

    @Nullable
    private static PsiElement getParent(@NotNull PsiElement element2, @Nullable BreadcrumbsProvider provider) {
        return provider != null ? provider.getParent(element2) : element2.getParent();
    }

    @Nullable
    private static BreadcrumbsProvider findProviderForElement(@NotNull PsiElement element2, BreadcrumbsProvider defaultProvider, boolean checkSettings) {
        Language language = element2.getLanguage();
        if (checkSettings && !BreadcrumbsUtilEx.isBreadcrumbsShownFor(language)) {
            return defaultProvider;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<? extends Pair<PsiElement, BreadcrumbsProvider>> pairs) {
        PsiElement[] elements2 = new PsiElement[pairs.size()];
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            elements2[index++] = (PsiElement)pair.first;
        }
        return elements2;
    }

    public static PsiElement @Nullable [] getLinePsiElements(Document document, int offset, VirtualFile file2, Project project, BreadcrumbsProvider infoProvider) {
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = PsiFileBreadcrumbsCollector.getLineElements(document, offset, file2, project, infoProvider, false);
        return pairs == null ? null : PsiFileBreadcrumbsCollector.toPsiElementArray(pairs);
    }
}

