/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.LazyTooltipCrumb;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiCrumb
extends Crumb.Impl
implements NavigatableCrumb,
LazyTooltipCrumb {
    private final PsiAnchor anchor;
    private volatile BreadcrumbsProvider provider;
    private volatile String tooltip;
    final CrumbPresentation presentation;

    PsiCrumb(@NotNull PsiElement element2, @NotNull BreadcrumbsProvider provider, @Nullable CrumbPresentation presentation2) {
        super(provider.getElementIcon(element2), provider.getElementInfo(element2), null, provider.getContextActions(element2));
        this.anchor = PsiAnchor.create(element2);
        this.provider = provider;
        this.presentation = presentation2;
    }

    public String getTooltip() {
        if (this.needCalculateTooltip()) {
            PsiElement element2 = PsiCrumb.getElement((Crumb)this);
            this.tooltip = element2 == null ? null : this.provider.getElementTooltip(element2);
            this.provider = null;
            FeatureUsageData data2 = new FeatureUsageData();
            if (element2 != null) {
                data2.addLanguage(element2.getLanguage());
            }
            UIEventLogger.logUIEvent((UIEventId)UIEventId.BreadcrumbShowTooltip, (FeatureUsageData)data2);
        }
        return this.tooltip;
    }

    public boolean needCalculateTooltip() {
        return this.provider != null && this.tooltip == null;
    }

    public int getAnchorOffset() {
        PsiElement element2 = this.anchor.retrieve();
        return element2 != null ? element2.getTextOffset() : -1;
    }

    @Nullable
    public TextRange getHighlightRange() {
        PsiElement element2 = this.anchor.retrieve();
        return element2 != null ? element2.getTextRange() : null;
    }

    public void navigate(@NotNull Editor editor, boolean withSelection) {
        int offset = this.getAnchorOffset();
        if (offset != -1) {
            PsiCrumb.moveEditorCaretTo(editor, offset);
        }
        FeatureUsageData data2 = new FeatureUsageData();
        PsiElement element2 = PsiCrumb.getElement((Crumb)this);
        if (element2 != null) {
            data2.addLanguage(element2.getLanguage());
        }
        if (withSelection) {
            data2.addData("with_selection", true);
            TextRange range2 = this.getHighlightRange();
            if (range2 != null) {
                editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
            }
        }
        UIEventLogger.logUIEvent((UIEventId)UIEventId.BreadcrumbNavigate, (FeatureUsageData)data2);
    }

    private static void moveEditorCaretTo(Editor editor, int offset) {
        if (offset >= 0) {
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Contract(value="null -> null")
    static PsiElement getElement(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).anchor.retrieve() : null;
    }

    @Contract(value="null -> null", pure=true)
    static CrumbPresentation getPresentation(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).presentation : null;
    }
}

