/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="XDebuggerSettings", storages={@Storage(value="debugger.xml")})
public class XDebuggerSettingManagerImpl
extends XDebuggerSettingsManager
implements PersistentStateComponent<SettingsState>,
Disposable {
    private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
    private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

    public static XDebuggerSettingManagerImpl getInstanceImpl() {
        return (XDebuggerSettingManagerImpl)XDebuggerSettingsManager.getInstance();
    }

    public SettingsState getState() {
        SettingsState settingsState = new SettingsState();
        settingsState.setDataViewSettings(this.myDataViewSettings);
        settingsState.setGeneralSettings(this.myGeneralSettings);
        for (XDebuggerSettings settings : XDebuggerSettings.EXTENSION_POINT.getExtensionList()) {
            Element serializedState;
            Object subState = settings.getState();
            if (subState == null || (serializedState = XmlSerializer.serialize((Object)subState)) == null) continue;
            SpecificSettingsState state = new SpecificSettingsState();
            state.id = settings.getId();
            state.configuration = serializedState;
            settingsState.specificStates.add(state);
        }
        return settingsState;
    }

    public Collection<XDebuggerSettings> getSettingsList() {
        return XDebuggerSettings.EXTENSION_POINT.getExtensionList();
    }

    @NotNull
    public XDebuggerDataViewSettings getDataViewSettings() {
        return this.myDataViewSettings;
    }

    public XDebuggerGeneralSettings getGeneralSettings() {
        return this.myGeneralSettings;
    }

    public void loadState(@NotNull SettingsState state) {
        this.myDataViewSettings = state.getDataViewSettings();
        this.myGeneralSettings = state.getGeneralSettings();
        for (SpecificSettingsState settingsState : state.specificStates) {
            XDebuggerSettings settings = XDebuggerSettingManagerImpl.findSettings(settingsState.id);
            if (settings == null) continue;
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)settings, (Element)settingsState.configuration);
        }
    }

    public void dispose() {
    }

    private static XDebuggerSettings findSettings(String id2) {
        return XDebuggerSettings.EXTENSION_POINT.extensions().filter(e -> id2.equals(e.getId())).findFirst().orElse(null);
    }

    @Tag(value="debugger")
    static class SpecificSettingsState {
        @Attribute
        public String id;
        @Tag
        public Element configuration;

        SpecificSettingsState() {
        }
    }

    public static class SettingsState {
        @XCollection(propertyElementName="debuggers")
        public List<SpecificSettingsState> specificStates = new SmartList();
        private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
        private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

        @Property(surroundWithTag=false)
        public XDebuggerDataViewSettings getDataViewSettings() {
            return this.myDataViewSettings;
        }

        public void setDataViewSettings(XDebuggerDataViewSettings dataViewSettings) {
            this.myDataViewSettings = dataViewSettings;
        }

        @Property(surroundWithTag=false)
        public XDebuggerGeneralSettings getGeneralSettings() {
            return this.myGeneralSettings;
        }

        public void setGeneralSettings(XDebuggerGeneralSettings generalSettings) {
            this.myGeneralSettings = generalSettings;
        }
    }
}

