/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent {
    static final Configurable[] EMPTY_CONFIGURABLES = new Configurable[0];
    private static final DebuggerSettingsCategory[] MERGED_CATEGORIES = new DebuggerSettingsCategory[]{DebuggerSettingsCategory.STEPPING, DebuggerSettingsCategory.HOTSWAP};
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;

    public String getDisplayName() {
        return DebuggerConfigurable.getDisplayNameText();
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger";
    }

    public Configurable @NotNull [] getConfigurables() {
        this.compute();
        if (this.myChildren.length == 0 && this.myRootConfigurable instanceof SearchableConfigurable.Parent) {
            return ((SearchableConfigurable.Parent)this.myRootConfigurable).getConfigurables();
        }
        return this.myChildren;
    }

    private void compute() {
        if (this.myChildren != null) {
            return;
        }
        SmartList configurables = new SmartList();
        configurables.add(new DataViewsConfigurable());
        DebuggerConfigurableProvider[] providers = (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions();
        DebuggerConfigurable.computeMergedConfigurables(providers, (List<? super Configurable>)configurables);
        for (DebuggerConfigurableProvider provider : providers) {
            configurables.addAll(provider.getConfigurables(DebuggerSettingsCategory.ROOT));
        }
        MergedCompositeConfigurable mergedGeneralConfigurable = this.computeGeneralConfigurables(providers);
        if (configurables.isEmpty() && mergedGeneralConfigurable == null) {
            this.myRootConfigurable = null;
            this.myChildren = EMPTY_CONFIGURABLES;
        } else if (configurables.size() == 1) {
            Configurable firstConfigurable = (Configurable)configurables.get(0);
            if (mergedGeneralConfigurable == null) {
                this.myRootConfigurable = firstConfigurable;
                this.myChildren = EMPTY_CONFIGURABLES;
            } else {
                Configurable[] generalConfigurables = mergedGeneralConfigurable.children;
                Configurable[] mergedArray = new Configurable[generalConfigurables.length + 1];
                System.arraycopy(generalConfigurables, 0, mergedArray, 0, generalConfigurables.length);
                mergedArray[generalConfigurables.length] = firstConfigurable;
                this.myRootConfigurable = new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedArray);
                this.myChildren = firstConfigurable instanceof SearchableConfigurable.Parent ? ((SearchableConfigurable.Parent)firstConfigurable).getConfigurables() : EMPTY_CONFIGURABLES;
            }
        } else {
            this.myChildren = configurables.toArray(new Configurable[0]);
            this.myRootConfigurable = mergedGeneralConfigurable;
        }
    }

    private static void computeMergedConfigurables(DebuggerConfigurableProvider @NotNull [] providers, @NotNull List<? super Configurable> result2) {
        for (DebuggerSettingsCategory category : MERGED_CATEGORIES) {
            List<Configurable> configurables = DebuggerConfigurable.getConfigurables(category, providers);
            if (configurables.isEmpty()) continue;
            String id2 = StringUtil.toLowerCase((String)category.name());
            result2.add((Configurable)new MergedCompositeConfigurable("debugger." + id2, XDebuggerBundle.message((String)("debugger." + id2 + ".display.name"), (Object[])new Object[0]), DebuggerConfigurable.getDefaultCategoryHelpTopic(category), configurables.toArray(new Configurable[0])));
        }
    }

    @Nullable
    private MergedCompositeConfigurable computeGeneralConfigurables(DebuggerConfigurableProvider @NotNull [] providers) {
        List<Configurable> rootConfigurables = DebuggerConfigurable.getConfigurables(DebuggerSettingsCategory.GENERAL, providers);
        if (rootConfigurables.isEmpty()) {
            return null;
        }
        Configurable[] mergedRootConfigurables = rootConfigurables.toArray(new Configurable[0]);
        Arrays.sort(mergedRootConfigurables, (o1, o2) -> {
            boolean c1e = StringUtil.isEmpty((String)o1.getDisplayName());
            return c1e == StringUtil.isEmpty((String)o2.getDisplayName()) ? 0 : (c1e ? -1 : 1);
        });
        return new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedRootConfigurables);
    }

    public void apply() throws ConfigurationException {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        this.compute();
        return this.myRootConfigurable != null;
    }

    public JComponent createComponent() {
        this.compute();
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        return "project.propDebugger";
    }

    @NotNull
    static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        return DebuggerConfigurable.getConfigurables(category, (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions());
    }

    @NotNull
    private static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category, DebuggerConfigurableProvider @NotNull [] providers) {
        List configurables = null;
        for (DebuggerConfigurableProvider provider : providers) {
            Collection providerConfigurables = provider.getConfigurables(category);
            if (providerConfigurables.isEmpty()) continue;
            if (configurables == null) {
                configurables = new SmartList();
            }
            configurables.addAll(providerConfigurables);
        }
        return ContainerUtil.notNullize(configurables);
    }

    private static String getDefaultCategoryHelpTopic(DebuggerSettingsCategory category) {
        switch (category) {
            case STEPPING: {
                return "reference.idesettings.debugger.stepping";
            }
            case HOTSWAP: {
                return "reference.idesettings.debugger.hotswap";
            }
        }
        return null;
    }

    public static String getDisplayNameText() {
        return XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);
    }
}

