/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDependentBreakpointManager {
    private final Map<XBreakpoint<?>, XDependentBreakpointInfo> mySlave2Info = new HashMap();
    private final MultiMap<XBreakpointBase, XDependentBreakpointInfo> myMaster2Info = new MultiMap();
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDependentBreakpointListener myEventPublisher;

    public XDependentBreakpointManager(@NotNull XBreakpointManagerImpl breakpointManager) {
        this.myBreakpointManager = breakpointManager;
        MessageBus messageBus = breakpointManager.getProject().getMessageBus();
        this.myEventPublisher = (XDependentBreakpointListener)messageBus.syncPublisher(XDependentBreakpointListener.TOPIC);
        MessageBusConnection busConnection = messageBus.connect();
        busConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                Collection infos;
                XDependentBreakpointInfo info = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpoint);
                if (info != null) {
                    XDependentBreakpointManager.this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
                }
                if ((infos = XDependentBreakpointManager.this.myMaster2Info.remove((Object)((XBreakpointBase)breakpoint))) != null) {
                    for (XDependentBreakpointInfo breakpointInfo : infos) {
                        XDependentBreakpointInfo removed = (XDependentBreakpointInfo)XDependentBreakpointManager.this.mySlave2Info.remove(breakpointInfo.mySlaveBreakpoint);
                        if (removed == null) continue;
                        XDependentBreakpointManager.this.myEventPublisher.dependencyCleared(breakpointInfo.mySlaveBreakpoint);
                    }
                }
            }
        });
    }

    public void loadState() {
        XBreakpointDependencyState state;
        XBreakpointBase<?, ?, ?>[] allBreakpoints;
        this.mySlave2Info.clear();
        this.myMaster2Info.clear();
        HashMap id2Breakpoint = new HashMap();
        for (XBreakpointBase<?, ?, ?> breakpoint : allBreakpoints = this.myBreakpointManager.getAllBreakpoints()) {
            String id2;
            state = breakpoint.getDependencyState();
            if (state == null || (id2 = state.getId()) == null) continue;
            id2Breakpoint.put(id2, breakpoint);
        }
        for (XBreakpointBase<?, ?, ?> breakpoint : allBreakpoints) {
            XBreakpointBase master;
            String masterId;
            state = breakpoint.getDependencyState();
            if (state == null || (masterId = state.getMasterBreakpointId()) == null || (master = (XBreakpointBase)id2Breakpoint.get(masterId)) == null) continue;
            this.addDependency(master, breakpoint, state.isLeaveEnabled());
        }
    }

    public void saveState() {
        THashMap breakpointToId = new THashMap();
        int id2 = 0;
        for (XBreakpointBase xBreakpointBase : this.myMaster2Info.keySet()) {
            breakpointToId.put(xBreakpointBase, String.valueOf(id2++));
        }
        for (XDependentBreakpointInfo xDependentBreakpointInfo : this.mySlave2Info.values()) {
            XBreakpointDependencyState state = new XBreakpointDependencyState((String)breakpointToId.get(xDependentBreakpointInfo.mySlaveBreakpoint), (String)breakpointToId.get(xDependentBreakpointInfo.myMasterBreakpoint), xDependentBreakpointInfo.myLeaveEnabled);
            xDependentBreakpointInfo.mySlaveBreakpoint.setDependencyState(state);
        }
        for (Map.Entry entry : breakpointToId.entrySet()) {
            if (this.mySlave2Info.containsKey(entry.getKey())) continue;
            ((XBreakpointBase)entry.getKey()).setDependencyState(new XBreakpointDependencyState((String)entry.getValue()));
        }
    }

    public void setMasterBreakpoint(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master, boolean leaveEnabled) {
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        if (info == null) {
            this.addDependency((XBreakpointBase)master, (XBreakpointBase)slave, leaveEnabled);
        } else if (info.myMasterBreakpoint == master) {
            info.myLeaveEnabled = leaveEnabled;
        } else {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            info.myMasterBreakpoint = (XBreakpointBase)master;
            info.myLeaveEnabled = leaveEnabled;
            this.myMaster2Info.putValue((Object)((XBreakpointBase)master), (Object)info);
        }
        this.myEventPublisher.dependencySet(slave, master);
    }

    public void clearMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info = this.mySlave2Info.remove(slave);
        if (info != null) {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            this.myEventPublisher.dependencyCleared(slave);
        }
    }

    private void addDependency(@NotNull XBreakpointBase<?, ?, ?> master, XBreakpointBase<?, ?, ?> slave, boolean leaveEnabled) {
        XDependentBreakpointInfo info = new XDependentBreakpointInfo(master, slave, leaveEnabled);
        this.mySlave2Info.put(slave, info);
        this.myMaster2Info.putValue(master, (Object)info);
    }

    @Nullable
    public XBreakpoint<?> getMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        return info != null ? info.myMasterBreakpoint : null;
    }

    public boolean isLeaveEnabled(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info = this.mySlave2Info.get(slave);
        return info != null && info.myLeaveEnabled;
    }

    public List<XBreakpoint<?>> getSlaveBreakpoints(XBreakpoint<?> breakpoint) {
        Collection slaveInfos = this.myMaster2Info.get((Object)((XBreakpointBase)breakpoint));
        if (slaveInfos.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList breakpoints = new SmartList();
        for (XDependentBreakpointInfo slaveInfo : slaveInfos) {
            breakpoints.add(slaveInfo.mySlaveBreakpoint);
        }
        return breakpoints;
    }

    public boolean isMasterOrSlave(XBreakpoint<?> breakpoint) {
        return this.myMaster2Info.containsKey((Object)((XBreakpointBase)breakpoint)) || this.mySlave2Info.containsKey(breakpoint);
    }

    public Set<XBreakpoint<?>> getAllSlaveBreakpoints() {
        return this.mySlave2Info.keySet();
    }

    class DependenciesData {
        private final Collection<XDependentBreakpointInfo> myDependencies = new SmartList();
        private final XBreakpointBase myBreakpoint;

        DependenciesData(XBreakpointBase breakpoint) {
            this.myBreakpoint = breakpoint;
            ContainerUtil.addIfNotNull(this.myDependencies, XDependentBreakpointManager.this.mySlave2Info.get(breakpoint));
            this.myDependencies.addAll(XDependentBreakpointManager.this.myMaster2Info.get((Object)breakpoint));
        }

        void restore(XBreakpointBase breakpoint) {
            this.myDependencies.forEach(d -> XDependentBreakpointManager.this.addDependency(this.replaceSelf(((XDependentBreakpointInfo)d).myMasterBreakpoint, breakpoint), this.replaceSelf(((XDependentBreakpointInfo)d).mySlaveBreakpoint, breakpoint), ((XDependentBreakpointInfo)d).myLeaveEnabled));
        }

        private XBreakpointBase replaceSelf(XBreakpointBase breakpoint, XBreakpointBase self) {
            return breakpoint == this.myBreakpoint ? self : breakpoint;
        }
    }

    private static class XDependentBreakpointInfo {
        private XBreakpointBase myMasterBreakpoint;
        private final XBreakpointBase mySlaveBreakpoint;
        private boolean myLeaveEnabled;

        private XDependentBreakpointInfo(@NotNull XBreakpointBase masterBreakpoint, XBreakpointBase slaveBreakpoint, boolean leaveEnabled) {
            this.myMasterBreakpoint = masterBreakpoint;
            this.myLeaveEnabled = leaveEnabled;
            this.mySlaveBreakpoint = slaveBreakpoint;
        }
    }
}

