/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.ExpandRegionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class XBreakpointUtil {
    private XBreakpointUtil() {
    }

    public static <B extends XBreakpoint> String getShortText(B breakpoint) {
        return StringUtil.shortenTextWithEllipsis((String)StringUtil.notNullize((String)breakpoint.getType().getShortText(breakpoint)), (int)70, (int)5);
    }

    public static <B extends XBreakpoint> String getDisplayText(@NotNull B breakpoint) {
        return breakpoint.getType().getDisplayText(breakpoint);
    }

    @Nullable
    public static XBreakpointType<?, ?> findType(@NotNull @NonNls String id2) {
        return ((StreamEx)XBreakpointUtil.breakpointTypes().filter(breakpointType -> id2.equals(breakpointType.getId()))).findFirst().orElse(null);
    }

    @NotNull
    public static StreamEx<XBreakpointType> breakpointTypes() {
        return StreamEx.of((Collection)XBreakpointType.EXTENSION_POINT_NAME.getExtensionList());
    }

    @NotNull
    public static Pair<GutterIconRenderer, Object> findSelectedBreakpoint(@NotNull Project project, @NotNull Editor editor) {
        XSourcePosition position;
        XBreakpoint<?> breakpoint;
        DebuggerSupport[] debuggerSupports;
        Document editorDocument;
        int textLength;
        int offset = editor.getCaretModel().getOffset();
        if (offset > (textLength = (editorDocument = editor.getDocument()).getTextLength())) {
            offset = textLength;
        }
        for (DebuggerSupport debuggerSupport : debuggerSupports = DebuggerSupport.getDebuggerSupports()) {
            BreakpointPanelProvider<?> provider = debuggerSupport.getBreakpointPanelProvider();
            Object breakpoint2 = provider.findBreakpoint(project, editorDocument, offset);
            if (breakpoint2 == null) continue;
            return Pair.create((Object)provider.getBreakpointGutterIconRenderer(breakpoint2), breakpoint2);
        }
        XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session2 != null && (breakpoint = session2.getActiveNonLineBreakpoint()) != null && (position = session2.getCurrentPosition()) != null && position.getFile().equals(FileDocumentManager.getInstance().getFile(editorDocument)) && editorDocument.getLineNumber(offset) == position.getLine()) {
            return Pair.create((Object)((XBreakpointBase)breakpoint).createGutterIconRenderer(), breakpoint);
        }
        return Pair.create(null, null);
    }

    public static List<BreakpointPanelProvider> collectPanelProviders() {
        ArrayList<BreakpointPanelProvider> panelProviders = new ArrayList<BreakpointPanelProvider>();
        for (DebuggerSupport debuggerSupport : DebuggerSupport.getDebuggerSupports()) {
            panelProviders.add(debuggerSupport.getBreakpointPanelProvider());
        }
        panelProviders.sort((o1, o2) -> o2.getPriority() - o1.getPriority());
        return panelProviders;
    }

    @Nullable
    public static DebuggerSupport getDebuggerSupport(Project project, BreakpointItem breakpointItem) {
        DebuggerSupport[] debuggerSupports = DebuggerSupport.getDebuggerSupports();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (DebuggerSupport support : debuggerSupports) {
            support.getBreakpointPanelProvider().provideBreakpointItems(project, items);
            if (items.contains(breakpointItem)) {
                return support;
            }
            items.clear();
        }
        return null;
    }

    @NotNull
    public static Promise<XLineBreakpoint> toggleLineBreakpoint(@NotNull Project project, @NotNull XSourcePosition position, @Nullable Editor editor, boolean temporary, boolean moveCaret, boolean canRemove) {
        FoldRegion region;
        int lineStart = position.getLine();
        VirtualFile file2 = position.getFile();
        int linesEnd = lineStart;
        if (editor != null && (region = FoldingUtil.findFoldRegionStartingAtLine(editor, lineStart)) != null && !region.isExpanded()) {
            linesEnd = region.getDocument().getLineNumber(region.getEndOffset());
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        XLineBreakpointType[] lineTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        SmartList typeWinner = new SmartList();
        int lineWinner = -1;
        if (linesEnd != lineStart) {
            for (int line = lineStart; line <= linesEnd; ++line) {
                int maxPriority = 0;
                for (XLineBreakpointType type : lineTypes) {
                    maxPriority = Math.max(maxPriority, type.getPriority());
                    XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file2, line);
                    if (!type.canPutAt(file2, line, project) && breakpoint == null || !typeWinner.isEmpty() && type.getPriority() <= ((XLineBreakpointType)typeWinner.get(0)).getPriority()) continue;
                    typeWinner.clear();
                    typeWinner.add(type);
                    lineWinner = line;
                }
                if (typeWinner.isEmpty() || ((XLineBreakpointType)typeWinner.get(0)).getPriority() != maxPriority) {
                    continue;
                }
                break;
            }
        } else {
            for (XLineBreakpointType type : lineTypes) {
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file2, lineStart);
                if (!type.canPutAt(file2, lineStart, project) && breakpoint == null) continue;
                typeWinner.add(type);
                lineWinner = lineStart;
            }
        }
        if (typeWinner.isEmpty()) {
            return Promises.rejectedPromise((Throwable)new RuntimeException("Cannot find appropriate type"));
        }
        XSourcePosition winPosition = lineStart == lineWinner ? position : XSourcePositionImpl.create(file2, lineWinner);
        Promise<XLineBreakpoint> res2 = XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, (List<? extends XLineBreakpointType>)typeWinner, winPosition, temporary, editor, canRemove);
        if (editor != null && lineStart != lineWinner) {
            int offset = editor.getDocument().getLineStartOffset(lineWinner);
            ExpandRegionAction.expandRegionAtOffset(project, editor, offset);
            if (moveCaret) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
        return res2;
    }
}

