/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import org.jetbrains.annotations.NotNull;

final class ShowLibraryFramesAction
extends ToggleAction {
    private static final String IS_LIBRARY_FRAME_FILTER_SUPPORTED = "isLibraryFrameFilterSupported";
    private volatile boolean myShouldShow = XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowLibraryStackFrames();

    ShowLibraryFramesAction() {
        super("", "", AllIcons.General.Filter);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        Object isSupported = presentation2.getClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED);
        XDebugSession session2 = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (isSupported == null) {
            if (session2 == null) {
                presentation2.setVisible(false);
                return;
            }
            isSupported = session2.getDebugProcess().isLibraryFrameFilterSupported();
            presentation2.putClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED, isSupported);
        }
        if (Boolean.TRUE.equals(isSupported)) {
            presentation2.setVisible(true);
            boolean shouldShow = !Toggleable.isSelected((Presentation)presentation2);
            presentation2.setText(XDebuggerBundle.message((String)(shouldShow ? "hide.library.frames.tooltip" : "show.all.frames.tooltip"), (Object[])new Object[0]));
        } else {
            presentation2.setVisible(false);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return !this.myShouldShow;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
        this.myShouldShow = !enabled;
        XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(this.myShouldShow);
        XDebuggerUtilImpl.rebuildAllSessionsViews(e.getProject());
    }
}

