/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.actions.ChooseDebugConfigurationPopupAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ResumeAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session2 != null && !session2.isStopped()) {
            return !session2.isReadOnly() && session2.isPaused();
        }
        return false;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (!this.performWithHandler(e) && (project = ResumeAction.getEventProject((AnActionEvent)e)) != null && !DumbService.isDumb((Project)project)) {
            new ChooseDebugConfigurationPopupAction().actionPerformed(e);
        }
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return debuggerSupport.getResumeActionHandler();
    }
}

