/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.osHandlers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.GenericAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.LinuxAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.MacAttachOSHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AttachOSHandler {
    private static final Logger LOGGER = Logger.getInstance(AttachOSHandler.class);
    @NotNull
    private final OSType myOSType;
    @NotNull
    protected final EnvironmentAwareHost myHost;

    public AttachOSHandler(@NotNull EnvironmentAwareHost host, @NotNull OSType osType) {
        this.myHost = host;
        this.myOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        return this.myOSType;
    }

    @NotNull
    public static AttachOSHandler getAttachOsHandler(@NotNull EnvironmentAwareHost host) {
        try {
            OSType osType = AttachOSHandler.computeOsType(host);
            if (osType == OSType.LINUX) {
                return new LinuxAttachOSHandler(host);
            }
            if (osType == OSType.MACOSX) {
                return new MacAttachOSHandler(host);
            }
            if (osType == OSType.WINDOWS) {
                return new GenericAttachOSHandler(host, OSType.WINDOWS);
            }
        }
        catch (ExecutionException e) {
            LOGGER.warn("Error while obtaining host operating system", (Throwable)e);
        }
        return new GenericAttachOSHandler(host, OSType.UNKNOWN);
    }

    @NotNull
    private static OSType localComputeOsType() {
        if (SystemInfo.isLinux) {
            return OSType.LINUX;
        }
        if (SystemInfo.isMac) {
            return OSType.MACOSX;
        }
        if (SystemInfo.isWindows) {
            return OSType.WINDOWS;
        }
        return OSType.UNKNOWN;
    }

    @NotNull
    private static OSType computeOsType(@NotNull EnvironmentAwareHost host) throws ExecutionException {
        if (host instanceof LocalAttachHost) {
            return AttachOSHandler.localComputeOsType();
        }
        try {
            OSType osType;
            String osString;
            GeneralCommandLine getOsCommandLine = new GeneralCommandLine(new String[]{"uname", "-s"});
            switch (osString = host.getProcessOutput(getOsCommandLine).getStdout().trim()) {
                case "Linux": {
                    osType = OSType.LINUX;
                    break;
                }
                case "Darwin": {
                    osType = OSType.MACOSX;
                    break;
                }
                default: {
                    osType = OSType.UNKNOWN;
                }
            }
            return osType;
        }
        catch (ExecutionException ex) {
            throw new ExecutionException("Error while calculating the remote operating system", (Throwable)ex);
        }
    }

    public static enum OSType {
        LINUX,
        MACOSX,
        WINDOWS,
        UNKNOWN;

    }
}

