/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAttachHost
extends EnvironmentAwareHost {
    public static final LocalAttachHost INSTANCE = new LocalAttachHost();

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() {
        return Arrays.asList(OSProcessUtil.getProcessList());
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new CapturingProcessHandler(commandLine);
    }

    @Override
    @Nullable
    public InputStream getFileContent(@NotNull String filePath) throws IOException {
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file2 == null) {
            return null;
        }
        return file2.getInputStream();
    }

    @Override
    public boolean canReadFile(@NotNull String filePath) {
        return new File(filePath).canRead();
    }

    @Override
    @NotNull
    public String getFileSystemHostId() {
        return "";
    }
}

