/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.ValuesCache;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J5\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00130\u00182\u0006\u0010\u0019\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016J5\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00130\u00182\u0006\u0010\u0019\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/workspaceModel/storage/VersionedEntityStorageOnBuilder;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;)V", "current", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "getCurrent", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "valuesCache", "Lcom/intellij/workspaceModel/storage/ValuesCache;", "version", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "intellij.platform.workspaceModel.storage"})
public final class VersionedEntityStorageOnBuilder
implements VersionedEntityStorage {
    private final ValuesCache valuesCache;
    private final AtomicReference<Pair<Long, WorkspaceEntityStorage>> currentSnapshot;
    private final WorkspaceEntityStorageBuilder builder;

    @Override
    public long getVersion() {
        return this.builder.getModificationCount();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorage getCurrent() {
        Pair<Long, WorkspaceEntityStorage> pair = this.currentSnapshot.get();
        if (pair == null || this.builder.getModificationCount() != ((Number)pair.getFirst()).longValue()) {
            WorkspaceEntityStorage snapshot = this.builder.toStorage();
            long count = this.builder.getModificationCount();
            this.currentSnapshot.set((Pair<Long, WorkspaceEntityStorage>)TuplesKt.to((Object)count, (Object)snapshot));
            return snapshot;
        }
        return (WorkspaceEntityStorage)pair.getSecond();
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value2) {
        return this.valuesCache.cachedValue(value2, this.getVersion(), this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        return this.valuesCache.cachedValue(value2, parameter, this.getVersion(), this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        this.valuesCache.clearCachedValue(value2);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        this.valuesCache.clearCachedValue(value2, parameter);
    }

    public VersionedEntityStorageOnBuilder(@NotNull WorkspaceEntityStorageBuilder builder2) {
        this.builder = builder2;
        this.valuesCache = new ValuesCache();
        this.currentSnapshot = new AtomicReference();
    }
}

